library ieee;
use ieee.std_logic_1164.all;
use ieee.numeric_std.all;

entity de2_vga_raster is
  
  port (
    reset		:in std_logic; 
    clk			:in std_logic; -- Should be 25.125 MHz for the VGA so I am gonna convert it
	read		:in std_logic; 
	write		:in std_logic; 
	chipselect	:in std_logic;            
	address    : in  unsigned(2 downto 0);
    writedata  : in  unsigned(31 downto 0);
	readdata   : out unsigned(31 downto 0);
	
    VGA_CLK,                         	  		-- Clock
    VGA_HS,                          	  		-- H_SYNC
    VGA_VS,                           	  		-- V_SYNC
    VGA_BLANK,                       	  		-- BLANK
    VGA_SYNC   : out std_logic;        	  		-- SYNC
    VGA_R,                           	   		-- Red[9:0]
    VGA_G,                           	  		-- Green[9:0]
    VGA_B 	   : out std_logic_vector(9 downto 0);-- Blue[9:0]

	LEDR : out std_logic_vector(17 downto 0);   -- Red LEDs (for debugging)
	
	TD_DATA : in std_logic_vector(7 downto 0);  -- Data bus 8 bits
    TD_HS,                                      -- H_SYNC
    TD_VS : in std_logic                       -- V_SYNC
    );

end de2_vga_raster;

architecture rtl of de2_vga_raster is
  
  -- Video parameters
  
  constant HTOTAL       : integer := 800;
  constant HSYNC        : integer := 96;
  constant HBACK_PORCH  : integer := 48;
  constant HACTIVE      : integer := 640;
  constant HFRONT_PORCH : integer := 16;
  constant HREAL		: integer := 1024;

  constant VTOTAL       : integer := 525;
  constant VSYNC        : integer := 2;
  constant VBACK_PORCH  : integer := 33;
  constant VACTIVE      : integer := 480;
  constant VFRONT_PORCH : integer := 10;
  constant VREAL		: integer := 1024;

  --sprites&tiles parameters
  constant HSPRITE		: integer := 32;	 
  constant VSPRITE		: integer := 32;	
  constant HTILE		: integer := 120;
  constant VTILE		: integer := 128;

-- Data structures (ROMS, RAM, Sprite position vectors, etc)
  type rom_type1 is array (0 to 8191)  	of unsigned (31 downto 0);	--memory, 	All the sprites (32x32x31spritesx8bits/32bits = 7936). Each sprite has 256 positions (8192 bits). Each row of one sprite has 8 positions (256 bits)
  type rom_type2 is array (0 to 255) 	of std_logic_vector (31 downto 0); 	--memory, 	Color table
  type rom_type3 is array (0 to 3839)	of unsigned (7 downto 0);  	--memory,   Tile
  type ram_type  is array (0 to 1023)  	of unsigned (9 downto 0);  	--memory,   Transparency layer (from top to bottom, reversed from Tony's)
  type sp_map  	 is array (0 to 31)		of unsigned (26 downto 0); 	--registers,Sprite positioning information [shown(1)|H(10)|V(10)|sprite#(5)|spriteFlip(1)]
  type buf		 is array (0 to 127)	of unsigned (31 downto 0);	--registers,Buffer for all the sprites in this row. (16 sprites*8 positions=128). 8 positions per sprite.

  -- Sprites definition
signal sprites : rom_type1 := (
----Sprite File for baseball08 (0)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","00111111001111110011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110011111101100100","10010010110110111010010001101101","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011011011110010011011011","11101101111000110000100111101101","10100011001111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01101101111001001110010000001001","00001001000010011110010000001001","00001001011001001111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101100111111","10100100000010011110010000001001","00001001000010011101101111010010","11011011110100100011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101101100100","11011011000010011101001011100100","00001001111001001111110011111100","11111100100100110011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011001101100101101111001001","11001001110100101111110011111100","11111100110010011101001011011100","10011100000000111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","01101101100100101100000011001001","10011011010110111100101010001001","11011100100110110000011111101111","10100101000000111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101100111111","01100100011001000110010000111111","00111111001111110000001101011011","10100101101001011010111010101111","10100101001101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110011111101011100","10100110010111010110010110101110","10100101001011010010110100101101","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110010110110011101","10100110101001010101110010101110","10100101100111011010011010100101","00101101111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011001101101010010110101110","10100101101001011010010110101111","10101110111011111110111110101111","01100100111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","00111111011001001010111011101111","10011101101001011010111111101111","11101111111011111110111111101111","10100101011001000011111111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101100111111","00100101011001011010010110100101","01011100101001011010111111101111","11101111101011101010010110101111","10101111101001010010110111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110110010110101100101","10101110101011100010010100110110","00111111011001000110010001100101","01100101011001010010010101100101","01100101010111000011011011111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011001011010110010110101111","10110111011001010011111111111011","11111011111110110011111100111111","00111111111110111111101100111111","00111111001111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","00101101011001011011011110110111","01100101001011011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101100101101","01100101101101111011011101100101","00101101111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101100000011","10101110101101110110011000101101","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","00100101011001000010111011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011001101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for baseball10 (1)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101100111111","00111111001111110011111100111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110010110101011011","11011011100110111010010010011100","00110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011011011110010011100100","00001001111011011110010000001001","11110111001101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01101101111001001110110111101101","00001001000010011110010011101101","00001001101001000011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01100100000010011110010000001001","00001001000010011110010011001001","11011011110100100011011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110110011011001011011","11010010111001001101001011010010","11100100110110111111110011111100","11111100100010010011011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","00111111011001001001000111111100","11111100110000001111110011111100","11001001110010011101101111011100","10011100011001001111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101100110110","10011011110010011001001001100100","01100100000000111001101110010010","10100100100110110000011111101111","10100110000000111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101100111111","00111111001111110011111111111011","11111011111110110010110110011100","10100101010111001010011010101111","10100101001011011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011001101110101110010100101","10100110010111000110010110101111","10100101001011010010110100101101","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","00110111011001011010111010100110","10100101010111001001110110101110","10100101100111011010011010100101","00101101111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101100101101","01011100101001101110111110100110","01011100101001011010111010101111","10101110111011111110111110101111","01100100111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011001101100010010101100110","10101110010111011001110101100100","01011100101011111110111111101111","11101111111011111110111111101111","10100101011001000011111111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101100110110","00000011011001101010111110101111","01100110001011010011011000111111","00000011101001011010111111101111","11101111101011101010010110101111","10101111101001010010110111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011001111110010110101100101","10101110101101111011011101100101","00110110111110111111101111111011","00111111011001000110010001100101","01100101011001010010010101100101","01100101010111000011011011111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011001011100110010110110111","10110111101011100110010100110110","11111011111110111111101111111011","11111011111110110011111100111111","00111111111110111111101100111111","00111111001111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011001101100110010110110111","01100101001011010011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110110010110100101101","00101101111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for baseball12 (2)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101100111111","00101101011001000110110000110110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110110110110100100","11011011110110111101101111100100","01100100001101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011011011110010011100100","00001001000010011110010011100101","00001001101001000011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","00111111111001000000100111011011","00001001000010010000100111011011","00001001111011010110010011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101100110110","10010010111011011110010111010010","00001001000010011110110111001001","11010010110100101001101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","00111111001101101001001011000000","11111100110010011111110011111100","11001001110100101100100111111100","11001001110010010010110111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101100111111","10011011100100101100100111001001","01011011011011011001001011001001","11010010100010011110010011100101","11100101010111000011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","00111111001111110011111100111111","11111011001111110101101110011100","10011101010111000000011111101111","10100110001001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","00110110000000110101110010100110","10100110010111001010011011101111","10100101001011011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110110011111100101101","01011100101001101010111010100101","10100110010111001010011011101111","10100101001011010010110100101101","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101100110110","00110110001001010110010101100101","10100101101011111010111110011100","10011100010111001010010110101110","10011101100111011010011010100101","00101101111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011001101100010010101100101","01101110101011111010111110101110","01011100011001000110010000110110","01100100101011101010111111101111","10101110111011111110111110101111","01100100111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"00110110011001101010111110110111","10110111101011100110010100101101","00111111001111111111101111111011","01100100101011111110111111101111","11101111111011111110111111101111","10100101011001000011111111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"00101101101011101011011110101110","01100101000000110011011011111011","11111011111110111111101111111011","00000011101001011010111111101111","11101111101011101010010110101111","10101111101001010010110111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"00110110001001010110010100101101","00110110111110111111101111111011","11111011111110111111101111111011","00111111011001000110010001100101","01100101011001010010010101100101","01100101010111000011011011111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011001111110011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110011111100111111","00111111111110111111101100111111","00111111001111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for baseball14 (3)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011001111110011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101101101","01100100100100101001101101101101","01101101001111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110110110111100100","11100100111001001110110111100100","11101101101001000011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011001101101110010000001001","11100100000010010000100111100100","00001001000010010110010011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101100110110","01100100110110110000100111100100","11101101000010010000100100001001","11011100000010011110010000111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","00110110011001001001001011000000","11111100111111001101001011001001","11010010111001001110010011010010","11111100110100101100100100110110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101100111111","00110110010110111001001010010010","10010010010110111000100111000000","11001001110010001100100111001001","11001001110010011001001000111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","00111111001111110010110110010011","10011100100100101110110111101110","11100110010111000011011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","00111111001111110011111100111111","00101101010111000101110010100110","10100110010111001010111011101111","10101110010111000011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"00110110001011010010110100101101","00011100010111010110010101100101","10100101101011111010111010100101","10100101011001011010011011101111","10100101001011011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"01100101011001101010111010101110","10101111101101111010111110100101","10100101101011101010011010011100","10011101100111011010011010101111","10100101001011010010110100101101","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"01100110111011111011011110110111","10101110011011010110010100100101","00000011011001000010010100000011","01011100101001011010011010101110","01011100100111001010011010100101","00000011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"01100101011001010110010100100101","00000011001101100011111111111011","11111011111110111111101111111011","01100101111011111110111110101111","10101110111011111110111110101111","01011100001111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"00111111001101100011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","01100100111011111110111111101111","11101111111011111110111111101111","10011101011001000011111111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","00000011101001101010111111101111","11101111101011111010010110101111","10101111101001010010110111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","00111111011001000110010001100101","01100101011001010010010101100101","01100101010111000011011011111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110011111100111111","00111111111110111111101100111111","00111111001111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for baseball16 (4)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","00110110011001000110010001100100","00101101001111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101100100","11011011111001011110001111100100","11011011100110110110110111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011001111110110010011100100","00001001111001000000100100001001","11101101111011011110010001101101","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011011001001001001010010010","10010010110010011100100100001001","11100100111001000000100100001001","00001001110110110000100110100100","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011001111110011011001011011","10010010100010011100000011111100","11111100110100100000100100001001","11101101110100100000100111100100","00110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011001111110011011010010010","11001001111111001111110011001001","11111100111111001101001011010010","00110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"00111111001111110011111100111111","00111111001111110011111111111011","00111111001111110010111001011100","01011011111001011001001011100100","11011011110010101100100110001001","00110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"01100101011011100110111001101110","01100101010111010010010100100101","01100100101001010101110010100101","10100110101001011111011100000111","11101111101001100101110000111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"10110111101101111011011110110111","10110111101101111010111010100101","10100101111011111010111010100101","10100110010111001010111011101111","10101111010111010010110111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"01100101011011100110111001101110","01101110011001010101110101011100","01011100101001101010010110011101","10011101010111001010011011101111","10100110000000111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"00111111001111110011111100111111","00111111001111110011111100111111","00101101000000110010110100000011","01011100100111011010010110101111","01100101001011010010110100101101","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01100101101011111110111110100110","01011100011001011010011010100101","00000011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01100101111011111110111111101111","10101111111011111110111110101111","01011100001111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01100100101011111110111111101111","11101111111011111110111111101111","10100101010111000011111111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","00000011101001011010111111101111","11101111101011111010011010101111","10101111101001010010110111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","00111111001011010110010001100101","01100101011001010010010101100101","01100101010111000011011011111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110011111100111111","00111111111110111111101100111111","00111111001111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for baseball18 (5)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011001011010110010001101101","01100100011011010011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101100111111","00111111001111110011111100111111","01101101111001001110110111100100","11100100110110111001101100101101","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110110010110110010010","11001001110010011100100111001001","11100100000010011101101111100101","00001001000010011110010011100100","00101101111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"00111111001101100011011011111011","11111011111110111111101100110110","01011011100100101100000011111100","11011011110110111101101100001001","00001001000010011101101100001001","10100100111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"00011100011001100110010100100101","00101101001101100011111111111011","11111011001111110011011000101101","11001001111111001111110011100100","00001001000010011101101100001001","11100100001101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"01100101101101111011011110110111","10101110011001100110010100000011","00110110001101100011011000110110","01011011100100101101001011001001","11001001111111001111110011100100","11011011001011011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"01011100101001101011011010110111","10110111101101111010111110101110","01011101101001101010010110011100","10100101101001010000011111100100","11100101110100111100100111111100","10010001001111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"00110110001011010010111000000011","01011100011001010110010101100101","10100101111011111010111110100101","10101110010111001010111011110110","11101111111011111010010101011011","00110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101100111111","00111111001111110011111100111111","01100101011001010110010110011101","10011101010111001010111011101111","11101111101011100101110000111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011001111110011011000100101","00000011010111011010011010101111","10101111101001010010110111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","00110110101001011010011010101110","10100110010111000010110100101101","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","00101101101011101110111110101111","10100101100111001010010110100101","01100100111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01011100101011101110111111101111","10101111101011111110111111101111","01100100001111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","00000011101011101110111111101111","11101111111011111110111111101111","10100101011001000011111111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","00111111101001011010111111101111","11101111101011111010011011101111","10101111101001010010110111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011001011100110010001100101","01100101011001010010110101100101","01100101010111000011011011111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110011111100111111","00111111111110111111101100111111","00111111001111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for bazooka00 (6)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101100111111","01101101011111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011001111110101110010100101","10100110101001011001101111011011","11011011101001001111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01111111101001011010111010101110","10101111111101111110001111100011","11011011101000111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01100101101011111010111001011100","11101111111101111001101110011011","10010010100110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01101110101011111010010111110111","11110110000001111001101101010010","00000000010110110111111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01101101101001011110111011110110","00000111000001110101110001010010","01001001100111010110111011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01110110101001010000100000000111","10100101100110111001110010011011","10010010100111000111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011111111010110101011011","10100101101001001110001111011011","11011010100110110110110111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101111111","10101101111101111110001111011011","10011010110110111010010101101110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01111111101001001001001001001001","01001001100100101010111010100110","01110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011101100101001000000000","00000000010100101010111010101111","10100101011101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011101101010010110011100","10011100101001011001110110101111","11101111100111011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110110110101101110","01101110011101100111111101101110","01101110011101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for bazooka08 (7)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110111111101111111","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01110110101001011010010110100101","10100101011011011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101110110","10100110101011111010011010100110","10101111101001010111111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101110011101","10101110101001010101110010101110","11101110111001001010010011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101110011100","11110111000001111111011000001000","11100100111000111110001111011011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101101110","00001000000001111111011110100100","10011011100110111101101111011011","01110101111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","10100100101001001001101101010010","01010010000000001001001010100011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01101110100110111001101110011011","00000000010010100101101101111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","10100100110110111101101111011011","10010010100111010101110011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101111111","01001001010100101001101111011011","10011011100111000101110000111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101110110","00000000000000001001001011011011","11110111101011101010111010100101","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01010010000000000101001011110111","11101111111011111110111110101110","01110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011011011010010111101111","11101111111011111010111111101111","10100101011101111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011101101010111011101111","11101111101011101010010110101111","11101111101001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110110110101101110","01101110011101100111111101101110","01101110011101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for bazooka16 (8)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01111111011111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110111011001100101","10100101101001010110010101110110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110101110010100110","10101111101011101010111010100110","01011100111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011101101010110111110111","10100101100111001010010110101111","10100110011101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011101101010010100000111","00000111000010000000011111101111","10101110011011011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011111110101101111110111","10011011111101110000011111101110","10100101011111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101100100","10011011101001001110001110100100","01010011100110111010010011100100","10011011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101100000000","01001001100110111110001110011011","01010010010110101001101111100011","11011011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101100000000","00000000100110111101101110011010","01001001000000000101001011011011","11011011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101011011","01010010110110111101101110011011","10011100010100111001101110011011","10100100111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01111111011011011010010010100101","10100101101001011010010010100101","01101110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011111111010011010101111","10101111101011111010111110101111","01101101111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011101101010111111101111","11101111111011111110111111101111","10100101011101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011011101010111111101111","11101111101011111010011010101111","10101111101001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110110111001101110","01101110011101110111111101101110","01101110011011011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for bazooka24 (9)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011111110110110101101110","01110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011101001010101110010100110","10101110101001010111111111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01101110101001010000011110101110","01011011101001011010010101111111","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01110110000010100101001001100100","01011100101001000000011111110111","00000111101001011010111001100101","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","00000000000000000101001011011011","11100100000001111010010010101101","11110110111011111010111101100101","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01001001010010011001101111011011","11100100000001110000100011110110","11101111111011111010111001101101","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01101101110110111101101111011011","10011011101001000000011111101111","11101111101011100110110111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011011011001101110010011","01001001010110111001101111110111","10101110011011011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110110010110011100","00001010010010011001101111100100","10100100111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110110111010011100","01010010010100101001101111100011","10101101111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111010010110100110","10100100110110111101101111100011","10011100111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011111111010011011101111","11101110111001001101101111100100","10100101011101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011111111010011011101111","11101111101011101010111011101111","10101111101001010111011011111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110111011101101110","01101110011011010110110101101110","01101110011011010111111111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for bazooka31 (10)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101101101","01111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110101101100000000","00000000011001000111111101100101","10011100010111000110110101111111","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011101100101000101001001","01001001100110111001110001011011","00000111101001101010010101100101","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011101101101101110011011","11011011111001001110110100000111","11110111101011100101110010100101","01111111111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111001101111011011","11011011111001000000011100000111","01011011000001111010010110100101","01100101111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011111111010010010011011","10011011101001001111011011110110","11110110000001111110111110101110","01100101111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011101101010010101010010","01001010101001000000011100001000","00000111111011111110111110101110","01100101111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011111110101110000001010","01001001100110111111011111101111","11101111101011111010011001100101","00111111111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111010001110010010","10010010100110111111011110100110","10100101011001010111011111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111010001110011011","11100011110110111001110010100101","10100110011011011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111010010011011011","11011011111001001111011111101111","10101110011011011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111010010111110111","11110111101011101010111111101111","10101111101001100110110111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110111011101101110","01101110011011100110110101101110","01101110011011100111111111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for blueArrow00 (11)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011001111110000001101011011","01011011000000110011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011000000111111001100001001","00001001111101000000001111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","00111111010110110000100100001001","11110110000010010110010011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","00110110010110100000100100001001","00001001000010010110010011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","00110110010110100000100100001001","00001001000010010110010011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011000110000100100001001","00001001000010010110001111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011000110000100100001001","00001001000010010110001111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011000110111111010000001001","00001001111101010001101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011000110111111001100001001","00001001111100110001101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","00110110101000111111010000001001","00001001111101001010001100110110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101100110110","10011010000010010000100100001001","00001001111111110000100110011010","00110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101100111111","10100011000010010000100100001001","00001001000010011111111101100011","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01100100000010010000100100001001","00001001000010010000100101100100","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","00110110101010110000100100001001","00001001000010011010101100110110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011000111111010000001001","00001001111101000110001111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011001101100110001100001001","00001001011000110011011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110011111101100011","01100011001111101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101100111111","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for blueReticle00 (12)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101100111110","00111110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110011011011110100","11110100001101010011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","00111111011101011011010000001001","00001001101101001011010000110110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101100111111","10110100001101010011111111110100","11110100001111110011111010110100","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101110101","00110101111110110011111111110100","11110100001111111111101100110101","01110101111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110011011010110100","00111111001111110011011011110100","11110100001101100011111100111111","10110100001101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011001111101111010000001001","11110100111101001111010011110110","11110110111101001111010011110100","00001001111101000011011011111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011001111101111010000001001","11110100111101001111010011110110","11110110111101001111010011110100","00001001111101000011111011111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110011011010110100","00111111001111110011011011110100","11110100001101100011111100111111","10110100001101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101110101","00111110111110110011111111110100","11110100001111111111101100111110","01110101111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101100111111","10101100001101010011011011110100","11110100001111110011111001110100","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","00111111011101011011010000001001","00001001101101000111010100111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110011011011110100","11110100001101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101100111110","00111110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for breathing00 (13)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011101100110110101101101","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101110110","10100101101011101010111010101110","10100101011001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101011100","10100110101001010101001110100101","10101111101001100111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101110100110","11101111000001110000011111101111","11101111101011100110110111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101110100101","00000111000010000000011100001000","11101111101011100111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101100101","01011011000001110101101100000111","11101111101011100111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101111111","10100101000001110000011100000111","11101111101001100011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","10101101111011110000011111101111","10101111101001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01110110101011101010111110101110","10101111011001010111111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011010111001010010110100110","10100110101001011010111010100101","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011100111001010111111101111","10101111101011111110111110101110","01110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011100111001010111111101111","11101111111011111010111110101111","01100101011101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011011101010111011101111","11101111101011101001110010101111","10101111100111001111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110110110101101110","01101110011101100111111101101110","01101110011101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for breathing03 (14)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011101100110110101101101","01110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101101110","10100101101011101010111010101110","10100101011001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101011100","10100110101001010101001110100101","10101111101001100111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101110100110","11101111111011110000011111101111","11101111101011100110110111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101110100101","00000111000001110000011100001000","11101111101011100111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101100101","01011011000001110101101100000111","11101111101011100111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101111111","10100101000001110000011100000111","11101111101001100011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","10101101111011110000011111101111","10101111101001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01110110101011101010111010101110","10101111100111000111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011010111001010010110100110","10101110101001011010111010100101","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011100111001010111111101111","10101111101011111110111110101110","01110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011100111011010111111101111","11101111111011111010111110101111","01100101011101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011011101010111011101111","11101111101011101001110010101111","10101111100111001111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110110110101101110","01101110011101100111111101101110","01101110011101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for breathing06 (15)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01111111011011010110110101101101","01110111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101101110","10100101101011101010011010101110","10100110011001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101011100","10100101101001010101001110100101","10101111101001100111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101110101110","00000111000001111111011011101111","11101111101011110110110111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101110100101","00000111000001111111011100001000","11101111101011100111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101100101","01011011000001110101101100000111","11101111101011100111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101111111","10101101000001110000011100000111","11101111101001100011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01110110111011111110111111101111","10101111101001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01110110101011101010111010101110","10101111101001010111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011010111001010010110100110","10101110101001011010111010100101","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011101001011010111111101111","11101111111011111110111110101110","01110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011101001011110111111101111","11101111111011111010111110101111","01100101011101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011011101010111011101111","11101111101011101001110110101111","10101111100111001111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110110110101101110","01101110011101100111111101101110","01101110011101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for breathing09 (16)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110011111100111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01110110011011011001110001011100","01101101001111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101110110","10100110101001101010010110100110","10101110100111010111111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101011100","10100101101001101010010010100110","11101111101011100110111011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101110101110","00001000000001111111011000000111","11101111101011110101110011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101110100101","10100101000001111010010000001000","11101111101011100110111011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101110110","01011011000001111001110000000111","11101111101011100111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","10100101000001110000011100000111","11101111101001100011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01101110111011111110111111101111","11101111101001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01111111101001011010011010100110","10101110101001010110010111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011010111001010010110100110","10101111101001101010111010100101","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011101001011110111111101111","11101111111011111110111110101110","01110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011101001011110111111101111","11101111111011111010111110101111","01100101011111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011001011010111111101111","11101111101011101001110110101111","10101111011001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110110111001101110","01101110011101100111111101101110","01101110011011101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for breathing12 (17)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011111110111111101111111","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101100111111","01100101101001011010010110100101","10011101011101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101100101","10100101101001010101110010100101","10101111101001010111111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101110011100","10101110101011101010111010101110","11101111101011110110010011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101110100110","00001000000010001111011000001000","11101111101011110101110011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101101101","10100100000001111001101100000111","11101111101011110110111011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101111111","01011011000001111010010000000111","11101111101011100111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01101101000001110000011100000111","11101111101011101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01110110101011101110111110101111","10101111101001101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011101001011010010110100101","10101110101001010110110111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011011011010011010101110","10101111101011101010111110100101","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011101001011110111111101111","11101111111011111110111110101110","01110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011101001101110111111101111","11101111111011111010111110101111","01100101011111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011101001011010111111101111","11101111101011101010010110101111","10101111011001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110110111001101110","01101110011101100111111101101110","01101110011011101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for breathing15 (18)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011111110111111101110111","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101100111111","01100101101001011010011010100110","10100101011011011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101011100","10100101101001010101110010100101","10101111101001100111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101110011101","10101110111011111110111111101111","11101111101011110110010111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101110100101","00000111000010000000100011110110","11101111101011110101110011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101101101","01011011000001110101101100000111","11101111101011110110111011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101100111111","10100100000001111111011100000111","11101111101011100111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01110110000001110000011111101111","11101111101011100011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01110110101011101010111110101110","10101111101011101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011010111001001110110011101","10101110101001010110110111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011011011010011010101110","11101111101011111010111110100101","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011101001101110111111101111","11101111111011111110111110101110","01110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011101011101110111111101111","11101111111011111010111110101111","01100101011111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011101001011010111111101111","11101111101011101010010110101111","10101111011001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011101100110110101101110","01101110011101100111111101101110","01101110011101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for breathing18 (19)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011111110111011001110110","01111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101100111111","01101101101001011010011010100110","10100101011001001111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101011100","10100101101001010101101110100101","10101111101001100110111011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101110100101","10101110111011110000011111101111","11101111101011110101110011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101110100101","00000111000010000000100011110110","11101111101011110101110011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101101101","01011011000001110101101100000111","11101111101011110110111011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101100111111","01100100000001111111011100000111","11101111101011100111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01110110000001110000011111101111","11101111101011100011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01111111101001101010111110101110","10101111101011101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011010111001001110110011101","10101110101001010110110111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011010111001010011010101110","11101111101011111010111110100101","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011101001101110111111101111","11101111111011111110111110101110","01110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011101011101110111111101111","11101111111011111010111110101111","01100101011111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011101001011010111111101111","11101111101011101010010110101111","10101110011011101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011101100110111001101110","01101110011101100111111101101110","01101110011101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for projectile0 (20)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101100111111","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110010010100001100","01011100001011011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011001111110000110101010110","00000111010111010011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011001111110000110100001101","01010101000011010011111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110010010100001100","00001100001001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101100111111","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for redArrow00 (21)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110111011101100101","01100101011101111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011111111010011110100111","11101111101001100111111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011010111001010011110100111","11110110111011110111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011010100111010011110100111","11101111000001110111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011010111001010011110100111","11101111111011110111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011101101010011110100111","10101111111011110111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011101101010011110100111","10101111111011110111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011101101010011110100111","10100111101011100111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011101101001111010100111","10100111100111100111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011010111011010011110100111","10100111101001110110010111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01011100101001111010011110100111","10100111000010001110111101011100","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01101101101001111010011110100111","10100111111011111111011001101101","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01110110101001111010011110100111","10100111111011111110111101110110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011001101010011110100111","10100111101011110110010111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011101101010011110100111","10100111101001110111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110110111010100111","10100111011011101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101101110","01101110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for redReticle00 (22)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101101111","01101111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011111110111011110100111","10100111011101110111011111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01101110111110111111101110101111","10101111111110111111101101110111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101111111","11111011111110111111101110101111","10101111111110111111101111111011","01111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101110111","11111011111110111111101110101111","10101111111110111111101111111011","01110111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110110111110100111","10101111101011111010111100001000","11110110101011111010111110101111","10100111011011111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110110111110100111","10101111101011111010111111110110","11110110101011111010111110101111","10100111011011111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101110111","11111011111110111111101110101111","10101111111110111111101111111011","01110111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101111111","11111011111110111111101110101111","10101111111110111111101111111011","01111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01110110111110111111101110100111","10101111111110111111101101110111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011111110110111110100111","10100111011101110111111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101101111","01101111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for wwalk00 (23)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110011111101111111","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011011011010010110100101","10100101011011011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","10100101101011101010011010100101","10101110101011100110010111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101101110","10011100101001101001110010100101","10101111111011111010010101110110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101101110","00000111111011111111011011110110","00000111111011111010011001101110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101100111111","10101101111101111111011110101101","00000111111011111010011001110110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01101101100111000000011110100100","00000111111011111010011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","00111111101011010000011100001000","11101111111011111010010111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011101101110111111101111","11101111101011111010010111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011111111010010110100110","10100101101011101001110000111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110110111010100110","10101111101001101010011010100101","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111010010111101111","11101111101011111110111110100110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011111111010011011101111","11101111111011111010111110100101","01110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011111111010011011101111","10101111101011101010111010101110","01101110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110110110101101110","01101110011011010110111001101110","01110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for wwalk02 (24)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01110110011011010110110101111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110110111010100101","10101110101011101010111010100101","01101101111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011111110101110010101110","10011101010110111010011011101111","10100101011111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011001011010010111101111","00000111000001111110111111101111","10100110011111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011111111111011100000111","00000111000001110000011111101111","10100110011111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110101110010100100","11110111101001000000011111101111","10100101011101111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110111111110101101","00000111000001110000011111101111","10100101111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101110101110","11101111000001111110111110101111","01100101111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101110110","10101110101011101010111010101111","10011100011001010111111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01100101101001011010011010101110","10100101101011101010010111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01110110101011101110111111101111","10101111111011111010111001110110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01110111101001101110111111101111","11101111111011111010111001100101","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011011001011010111011101111","10101111101001101010111010100110","01101110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110110110101101110","01101110011011010110111001101110","01110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for wwalk04 (25)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011111110110110101101101","01100101011011010111111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01111111101001011010111010100110","10100110101011101010010101111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01100101100111001010011001011100","10100101101011111010111101100101","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","10101110000010001110111111110110","00001000111011111010111110100101","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01101110101001010000011110100100","00001000111011111010111101101101","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","00111111010110110000011110011100","00000111111011111010111101100101","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011011100000011100000111","00000111111011111010111001110110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011001111111010111011101111","11101111111011111010010101111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111010010110100110","10100110101011111010010111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110111111110100101","10101110101011111010010101101101","01101101011111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101110100110","11101111111011111010111110101110","10101111101001100111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101110100101","11101111111011111110111111101111","11101111111011111010111001101110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101101110110","10101110101011111010111110101110","10100101101011101010111110101110","01101110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","01110110011011100110111001101110","00111111011111110110111001101110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for wwalk06 (26)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011011100110110101101101","01101101011111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101101111111","10100101101011101010111010100110","10101110101001010111011011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101101101101","01011100101001100101110001011100","10101110101011110110010111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101101100101","00000111111011111111011000001000","11101111111011111010010101111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101101110110","10100100000001111010110100001000","11101111111011111010010111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101101111111","01011011000001110101101100000111","11101111101011110110110111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01101101000001110000011100000111","11101111101011100111111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01111111111011111110111111101111","11101111101001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","00111111101001011010111010100110","10101111101001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011001011010010110100110","10101110011011011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011011011010111111101111","11101111101001101010010110100101","01100101011011101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011101101010111011101111","11101111111011111110111111101111","11101111101011101010010101110110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111010010110101111","10101111101011111010111110101111","10101111101011111010111110100110","01101110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110111111101101101","01101110011011100110110101101101","01101101011011010110111001101101","00111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for wwalk08 (27)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110111111101111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01101110101001011010010110011101","01100101011111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101101100101","10100110101001101010010110100110","10101110101001010111111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110110111111110100101","10100110101001101010010110100110","11101111101011100110010111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110110111111110101110","00000111000010001111011000000111","11101111101011100110110111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101101100100","10100100000001111010010011110110","11101111101011100110111011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101101110110","10100101111011101010010000000111","11101111101001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","10110110000001110000100011101111","10101111011001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","10101110111011111110111111101111","10101111011011011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01110110101001011010010110101110","10100110011101111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01111111101001011010111010101111","10100101011111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01111111101001101110111111101111","10101111101011101010111010100110","10100101011011101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01111111101001101110111111101111","11101111111011111110111111101111","11101111101011111010010101111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011011011010111110101111","10101111101011111010111010100110","10100101101001101010011001110110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011111110110110101101110","01101110011011010111111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for wwalk10 (28)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01111111011011010110010101101101","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101101100101","10100110101011101010111010100110","01100100011111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110110110010110011101","10100110010111000101110010101110","10101110010111001111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110110110010111101110","11101111000001110000011111101111","11101111101001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110110110110111110111","00001000000001110000100011101111","11101111100111011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110110111111101011011","00000111010110110000011111101111","10101111011011011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101101101101","00000111000001110000011111101111","10101110011101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101101111111","11101111000001111110111111101111","10100110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101101111111","10100110101011111010111010101111","10100101111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01110110101001011010010110101111","01100101001111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01111111101011101110111111101111","10100101101001011010011010100101","01101101111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01111111101011111110111111101111","11101111111011111110111111101111","10101110011011011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01111111101011101110111111101111","11101111111011111010011010100101","10101110101001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011101001011010111110101111","10101111101001010111111111111011","01110110011111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011111110110111001101110","01101101011111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for wwalk12 (29)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101101111111","01101101011001011010010101101101","01101101111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110110111111110100101","10101110101001101010010110101110","10100101011101101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110110110010110011101","10100110010111001010010110101111","10101111011001001111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111010010100000111","11101111111101101111011011101111","11101111101001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110110111011010100101","00000111111101110000011111101111","11101111100111001111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101101011100","11110111101001001111011111101111","10101111011011011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101101110110","00000111000001110000100011101111","10101111011011011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","10101110111011111110111111101111","10101110011011101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01101101101001101010010110101110","10100110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01111111101001011010011010101111","10100101011111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01111111101001101110111111101111","10101110101001101010011001101110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01111111101011101110111111101111","11101111111011111110111110100101","01111111111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01111111101011101110111111101111","11101111101011111010111110101110","01100101111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011101001011010111110101111","10101110011011010110111010100101","01101101111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011111110110111001101110","01110110111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--Sprite File for wwalk14 (30)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110111111101111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01101110101001011010010110100101","01100101011111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101101101101","10101110101001101010010110101110","10101111101001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110110111111101011100","10100110101001011010010110101110","11101111101001100110111011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110110111111110101110","00000111000010001111011000000111","11101111101011100110010111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101110101101","11110111000001111010010011110110","11101111101011100110111011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101101110110","01011011000001111010010000000111","11101111101001101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","10101101000001110000100000000111","11101111101001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01111111101011101110111111101111","11101111101001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011001011010011010100101","10101110100111010111111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011111111010011010101110","10101110101001101010010111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011011101110111111101111","10101111111011111010011001111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011101001011110111111101111","11101111101011111010010101101110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011101001011010111110101111","10101110101011101010111001101101","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011111110110111001101110","01101101011011100110111001111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",

--extra sprite (31)
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110110111111101111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01101110101001011010010110100101","01100101011111111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101101101101","10101110101001101010010110101110","10101111101001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110110111111101011100","10100110101001011010010110101110","11101111101001100110111011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110110111111110101110","00000111000010001111011000000111","11101111101011100110010111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101110101101","11110111000001111010010011110110","11101111101011100110111011111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101101110110","01011011000001111010010000000111","11101111101001101111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","10101101000001110000100000000111","11101111101001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","01111111101011101110111111101111","11101111101001011111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011001011010011010100101","10101110100111010111111111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011111111010011010101110","10101110101001101010010111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011011101110111111101111","10101111111011111010011001111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011101001011110111111101111","11101111101011111010010101101110","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011101001011010111110101111","10101110101011101010111001101101","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011011111110110111001101110","01101101011011100110111001111111","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011",
"11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011","11111011111110111111101111111011");

  -- Color look-up table
signal color: rom_type2 := ( 
	"00000000000000000000000000000000", "10000000000000000000000000000000", "00000000001000000000000000000000", "10000000001000000000000000000010", 
	"00000000000000000000100000000000", "10000000000000000000100000000000", "00000000001000000000100000000000", "11000000001100000000110000000000", 
	"11000000001101110000110000000000", "10100110001100101000111100000000", "01000000000010000000000000000000", "01100000000010000000000000000000", 
	"10000000000010000000000000000000", "10100000000010000000000000000000", "11000000000010000000000000000000", "11100000000010000000000000000000", 
	"00000000000100000000000000000000", "00100000000100000000000000000000", "01000000000100000000000000000010", "01100000000100000000000000000000", 
	"10000000000100000000000000000000", "10100000000100000000000000000000", "11000000000100000000000000000000", "11100000000100000000000000000000", 
	"00000000000110000000000000000000", "00100000000110000000000000000000", "01000000000110000000000000000000", "01100000000110000000000000000010", 
	"10000000000110000000000000000000", "10100000000110000000000000000000", "11000000000110000000000000000000", "11100000000110000000000000000000", 
	"00000000001000000000000000000000", "00100000001000000000000000000000", "01000000001000000000000000000000", "01100000001000000000000000000000", 
	"10000000001000000000000000000010", "10100000001000000000000000000000", "11000000001000000000000000000000", "11100000001000000000000000000000", 
	"00000000001010000000000000000000", "00100000001010000000000000000000", "01000000001010000000000000000000", "01100000001010000000000000000000", 
	"10000000001010000000000000000000", "10100000001010000000000000000010", "11000000001010000000000000000000", "11100000001010000000000000000000", 
	"00000000001100000000000000000000", "00100000001100000000000000000000", "01000000001100000000000000000000", "01100000001100000000000000000000", 
	"10000000001100000000000000000000", "10100000001100000000000000000000", "11000000001100000000000000000010", "11100000001100000000000000000000", 
	"00000000001110000000000000000000", "00100000001110000000000000000000", "01000000001110000000000000000000", "01100000001110000000000000000000", 
	"10000000001110000000000000000000", "10100000001110000000000000000000", "11000000001110000000000000000000", "11100000001110000000000000000010", 
	"00000000000000000000010000000000", "00100000000000000000010000000000", "01000000000000000000010000000000", "01100000000000000000010000000000", 
	"10000000000000000000010000000000", "10100000000000000000010000000000", "11000000000000000000010000000000", "11100000000000000000010000000000", 
	"00000000000010000000010000000000", "00100000000010000000010000000010", "01000000000010000000010000000000", "01100000000010000000010000000000", 
	"10000000000010000000010000000000", "10100000000010000000010000000000", "11000000000010000000010000000000", "11100000000010000000010000000000", 
	"00000000000100000000010000000000", "00100000000100000000010000000000", "01000000000100000000010000000010", "01100000000100000000010000000000", 
	"10000000000100000000010000000000", "10100000000100000000010000000000", "11000000000100000000010000000000", "11100000000100000000010000000000", 
	"00000000000110000000010000000000", "00100000000110000000010000000000", "01000000000110000000010000000000", "01100000000110000000010000000010", 
	"10000000000110000000010000000000", "10100000000110000000010000000000", "11000000000110000000010000000000", "11100000000110000000010000000000", 
	"00000000001000000000010000000000", "00100000001000000000010000000000", "01000000001000000000010000000000", "01100000001000000000010000000000", 
	"10000000001000000000010000000010", "10100000001000000000010000000000", "11000000001000000000010000000000", "11100000001000000000010000000000", 
	"00000000001010000000010000000000", "00100000001010000000010000000000", "01000000001010000000010000000000", "01100000001010000000010000000000", 
	"10000000001010000000010000000000", "10100000001010000000010000000010", "11000000001010000000010000000000", "11100000001010000000010000000000", 
	"00000000001100000000010000000000", "00100000001100000000010000000000", "01000000001100000000010000000000", "01100000001100000000010000000000", 
	"10000000001100000000010000000000", "10100000001100000000010000000000", "11000000001100000000010000000010", "11100000001100000000010000000000", 
	"00000000001110000000010000000000", "00100000001110000000010000000000", "01000000001110000000010000000000", "01100000001110000000010000000000", 
	"10000000001110000000010000000000", "10100000001110000000010000000000", "11000000001110000000010000000000", "11100000001110000000010000000010", 
	"00000000000000000000100000000000", "00100000000000000000100000000000", "01000000000000000000100000000000", "01100000000000000000100000000000", 
	"10000000000000000000100000000000", "10100000000000000000100000000000", "11000000000000000000100000000000", "11100000000000000000100000000000", 
	"00000000000010000000100000000000", "00100000000010000000100000000000", "01000000000010000000100000000000", "01100000000010000000100000000000", 
	"10000000000010000000100000000000", "10100000000010000000100000000000", "11000000000010000000100000000000", "11100000000010000000100000000000", 
	"00000000000100000000100000000000", "00100000000100000000100000000000", "01000000000100000000100000000000", "01100000000100000000100000000000", 
	"10000000000100000000100000000000", "10100000000100000000100000000000", "11000000000100000000100000000000", "11100000000100000000100000000000", 
	"00000000000110000000100000000000", "00100000000110000000100000000000", "01000000000110000000100000000000", "01100000000110000000100000000000", 
	"10000000000110000000100000000000", "10100000000110000000100000000000", "11000000000110000000100000000000", "11100000000110000000100000000000", 
	"00000000001000000000100000000000", "00100000001000000000100000000000", "01000000001000000000100000000000", "01100000001000000000100000000000", 
	"10000000001000000000100000000000", "10100000001000000000100000000000", "11000000001000000000100000000000", "11100000001000000000100000000000", 
	"00000000001010000000100000000000", "00100000001010000000100000000000", "01000000001010000000100000000000", "01100000001010000000100000000000", 
	"10000000001010000000100000000000", "10100000001010000000100000000000", "11000000001010000000100000000000", "11100000001010000000100000000000", 
	"00000000001100000000100000000000", "00100000001100000000100000000000", "01000000001100000000100000000000", "01100000001100000000100000000000", 
	"10000000001100000000100000000000", "10100000001100000000100000000000", "11000000001100000000100000000000", "11100000001100000000100000000000", 
	"00000000001110000000100000000000", "00100000001110000000100000000000", "01000000001110000000100000000000", "01100000001110000000100000000000", 
	"10000000001110000000100000000000", "10100000001110000000100000000000", "11000000001110000000100000000000", "11100000001110000000100000000000", 
	"00000000000000000000110000000000", "00100000000000000000110000000000", "01000000000000000000110000000000", "01100000000000000000110000000000", 
	"10000000000000000000110000000000", "10100000000000000000110000000000", "11000000000000000000110000000000", "11100000000000000000110000000000", 
	"00000000000010000000110000000000", "00100000000010000000110000000000", "01000000000010000000110000000000", "01100000000010000000110000000000", 
	"10000000000010000000110000000000", "10100000000010000000110000000000", "11000000000010000000110000000000", "11100000000010000000110000000000", 
	"00000000000100000000110000000000", "00100000000100000000110000000000", "01000000000100000000110000000000", "01100000000100000000110000000000", 
	"10000000000100000000110000000000", "10100000000100000000110000000000", "11000000000100000000110000000000", "11100000000100000000110000000000", 
	"00000000000110000000110000000000", "00100000000110000000110000000000", "01000000000110000000110000000000", "01100000000110000000110000000000", 
	"10000000000110000000110000000000", "10100000000110000000110000000000", "11000000000110000000110000000000", "11100000000110000000110000000000", 
	"00000000001000000000110000000000", "00100000001000000000110000000000", "01000000001000000000110000000000", "01100000001000000000110000000000", 
	"10000000001000000000110000000000", "10100000001000000000110000000000", "11000000001000000000110000000000", "11100000001000000000110000000000", 
	"00000000001010000000110000000000", "00100000001010000000110000000000", "01000000001010000000110000000000", "01100000001010000000110000000000", 
	"10000000001010000000110000000000", "10100000001010000000110000000000", "11000000001010000000110000000000", "11100000001010000000110000000000", 
	"00000000001100000000110000000000", "00100000001100000000110000000000", "01000000001100000000110000000000", "01100000001100000000110000000000", 
	"10000000001100000000110000000000", "10100000001100000000110000000000", "11111111001111101100111100000000", "10100000001010000000101001000000", 
	"10000000001000000000100000000000", "11111111000000000000000000000000", "00000000001111111100000000000000", "11111111001111111100000000000010", 
	"00000000000000000000111111110000", "11111111000000000000111111110000", "00000000001111111100111111110000", "11111111001111111100111111110000");
 

  -- Tiles table  
signal tile : rom_type3 := (
"10011011","01011011","10100011","10011011","10011011","01011011","01011010","01011010","01010011","01010001","00001010","01001001","01011010","10100100","10100011","10101100","10100011","10011011","01011011","01010011","01010001","00001010","01001001","01011010","10011011","10100011","10011011","10100011","01010011","01011011","01011011","01011010",
"01011010","01001010","00001010","00001010","00001010","01001001","00001010","00001010","01001001","00001010","01001001","01001001","01001001","00001010","00001010","00001010","00010010","01001001","00001010","01001010","10100011","10101100","10101100","10101100","10101100","10101100","10100011","10101100","10101100","10101100","10100011","10011011",
"10011011","01011011","01011011","01011011","01011011","01011010","01011010","01010011","01010001","00001010","01001001","01010010","01010011","10011011","10100011","10011011","10011011","01011010","01010010","01011010","01001010","00001010","01001010","01010010","10011011","10011011","10011011","10011011","01011011","01011010","01011010","01010011",
"01001010","01001001","01001001","01010010","01010010","10011011","10100100","10100011","10100011","10100011","01100011","01010010","00011011","01001001","01001010","00000000","01001001","00001010","01001010","01010010","10101100","10101100","10101100","10101100","10101100","10100100","10100011","10101100","10101100","10100100","10011011","10011011",
"01011011","01011010","01011011","01011011","01011010","01011010","01010011","01010001","00001010","01001001","00001010","00001010","01001010","01010010","10011010","01011011","01011010","01010011","01011010","01001010","00001010","00001010","00001010","01010001","10100100","10011011","10011011","01011011","01011010","01011011","01010010","01010001",
"01010010","01001010","01011010","10100100","11101101","10101100","11110111","11110111","11110111","10101100","11100100","10011011","01011010","01010011","01001001","01001001","00001010","00001010","01001001","01011011","11100100","10101100","10100100","10101100","10101100","10100011","10100100","10101100","11101100","10100011","10011011","10011011",
"01011011","01011010","01011011","01011010","01011010","01010010","01010001","00001010","00001010","00010001","01001001","00001010","00001010","01001001","01001010","01010001","00010010","01010001","01001010","00001010","01001001","01001001","01001001","00001010","01010010","01011011","01011010","10011010","01011011","01001010","01010010","00001010",
"01010010","10100011","11110111","11110111","10101100","11110111","11110111","11110111","10101011","10100100","10100100","10011011","01011010","01011010","01010011","01001010","00000000","00001010","01010010","01011010","10101100","10100011","10101100","11110111","10100100","10100100","10100011","11110111","10100100","10011011","10011011","01011010",
"01011010","01011010","01011010","01010011","01010011","00001010","01001001","01001001","01001010","01010010","00000000","00001010","00001010","01001010","00001010","01010010","01001001","01001010","01010001","01001010","01010010","01011011","10011011","01010011","01001001","01010010","01011011","01010011","00010001","01001001","01001010","01011011",
"10100011","11110101","11110111","10100011","11110111","11101100","10101100","11100011","10100100","10100011","01011010","01011010","01011011","01011011","01001001","00001010","01000001","00001010","01010010","10011011","01011011","11110111","11110111","11110111","10100011","10100100","10100100","10101100","10011011","10011011","10100011","01011010",
"01010010","01011011","01001010","01001001","00001010","01010010","01011011","01011011","01001010","00001010","00001010","01001010","01010001","00001010","01010010","01011010","10011100","01011010","01010010","10011011","10100011","10100011","10011011","01011010","00001010","01001001","01001010","01001001","01001001","00001010","01011011","10100100",
"11110111","11110111","10100011","10100100","10100011","10100100","10100100","10100011","01011011","01010010","01011011","01011010","01011011","01010010","01001010","00001010","00001010","01001010","01010010","01011011","10100100","10101100","11110111","11110111","10100011","10100100","10100011","10100011","01011011","10100011","01010010","01011011",
"01010010","01001001","01010010","01011011","10101100","10100011","01011010","01010010","00001010","01001001","01001010","01010010","01100011","10100011","10100011","10011011","01100011","10100011","10101100","10100100","10101100","01011011","10011011","01011011","01010001","00001010","00001010","01001010","00001010","01011011","10100100","11110111",
"11110111","10100011","10100100","10100011","10101100","10011011","10011011","01010011","01011010","01011011","01011010","01010010","01010001","01001010","00001010","00000000","00010010","01001001","01011010","10011011","11101100","11101100","11110111","10101100","10100100","01100011","10011011","10011011","10100011","01010010","01011011","01011010",
"00001010","10100100","11101100","10101100","10011011","01011010","01010010","00001010","01001010","01010010","10100011","10101100","10101100","10100011","10011011","10100011","11110111","10100100","10100011","10100100","10100011","10011011","01011011","01011010","01010001","00001010","01001010","00010001","01011011","10101100","11101101","11110111",
"10100011","10100011","10100100","10101100","10100011","01011011","01011010","01011010","01011011","01011010","01010010","01001010","00001010","00001010","00001010","00000000","00001010","01001001","01011010","10100011","10101100","11110111","10110101","10100011","10100011","10011011","10011011","10011011","01011010","01011011","01011010","01010010",
"11110111","11101100","10100011","01010010","01010010","01001010","00001010","01010010","10100011","11110101","11110111","10101100","10100011","10100100","11110111","10101100","10101011","10100100","10100100","10100100","10100011","10011011","01011010","01011010","01010010","00001010","01010001","01010010","10101100","11110111","11110111","11100011",
"10100011","10011011","10101100","10100011","01010011","01011010","01011011","01011011","01010010","01001001","01001010","00001010","00001010","00001010","01001010","01001010","00001010","01001010","01010010","10101100","11110111","11110100","10101100","10100100","10011011","10011011","01011011","01011010","10011011","01011010","01010010","01011011",
"10100011","01011011","01010010","01001001","00001010","01010010","10011011","11101101","10110101","11110111","10101100","11110111","10101100","10101100","10100011","10100100","10100100","10011011","10100011","10011011","10011011","01011010","10011010","01011011","01001001","01001001","01010010","10100100","10101100","11110111","11100011","10100100",
"01011011","01011010","01011011","01010011","01011010","01011010","01010011","01001001","01010010","00001010","01001001","01010010","01010010","01010010","01001001","00001010","00001010","01001001","01010010","11110111","11110100","10100100","11110111","10100011","10011011","01011011","01011011","01011010","01011010","01010010","01010010","11101100",
"01010010","01010010","01001001","01010011","01010010","10100100","11110101","11110111","11110111","11110111","10100100","10101100","10101100","11110111","10101100","10100011","10100100","10100011","10100011","10011011","01011011","01011010","01011010","01010011","00001010","01010010","10100011","11110111","10101100","10100011","10100011","01011011",
"01011010","01011011","01011011","10011010","01011011","01010010","01001001","01010010","01010010","01010010","01010010","10011011","10011011","10011011","01011011","01010001","00001010","00001010","01011010","11100100","10101100","10101100","10100011","10011011","10011011","01011010","01011011","01011010","01010010","01001010","10100011","01011011",
"01001010","00010001","01010011","01011010","11110111","11110111","11110111","11110111","11101100","10101100","11110111","11110111","11110111","10101100","10100100","10100100","10100011","01011011","10011011","01010011","01011010","01011010","01010010","01010011","01001001","10011011","10101100","10100100","10100100","10100100","01010011","01011010",
"01011010","01011010","01011010","01010011","00001010","01010010","01010010","01010010","01010010","10100011","11110101","10101100","11110111","10100011","01011010","01010011","00001010","01001001","01010010","11101100","10101100","10100100","10100011","10011011","10100011","01011011","01011010","01010011","01001001","01010010","01010010","01010001",
"00001010","01010011","10011011","10101100","10101100","10101100","11100100","11110111","11110111","11110111","11110111","11101100","10101100","10100011","10100100","10100011","01011011","10100011","10011011","10100011","01011011","01010010","01010011","01010010","00010010","10011011","10101100","10101100","10011011","01011011","01011010","01011010",
"01011011","01010010","01010010","00001010","01010010","01010011","01010010","01010011","10101100","11101101","11110111","10100011","10100100","10100011","01011011","01010010","01001010","01001001","01010010","10101100","10100100","10100011","10011011","10100011","01010010","01011011","01010010","00001010","00001010","00001010","00001010","00001010",
"01011010","10100100","11110111","11110111","11110111","10101100","11100100","10110101","11101100","11110111","10100100","10101100","10100011","10100100","10100100","10100011","10100011","10011011","10011011","01011010","01011011","01010010","01011010","00010010","01001001","01011011","10011011","10011011","01011011","01011010","01011010","01010010",
"01001010","01010010","00001010","01010010","10011010","01010010","01011011","11101100","11110111","11101100","10100100","10101100","10100100","10011011","01011010","01010011","01001001","01001001","01010010","10011011","10100011","10100011","10011011","01010011","01011010","01010010","01010010","01001010","00001010","00001010","01001001","01010010",
"10101101","11110111","11110111","11110111","11110111","11110111","10110101","11101100","10101100","10101100","11110111","11110111","10101100","10100100","11101011","10100100","10100011","10100011","10011011","01011011","01011010","01011010","01010011","01010001","01010010","01010011","01011010","01011011","01011010","01011011","01010010","00001010",
"01010010","01010010","01011010","10100011","01010010","10011011","11110111","10100100","10101011","10100011","10100100","10100100","10100011","01010011","01011011","01010010","00001010","01001001","01011010","10011011","10011011","01011011","01011010","01011010","01010011","01010010","00001010","01001001","01001001","00001010","00010010","10100011",
"11110111","11110111","10110100","11100100","11110111","10110100","11100100","10101100","10100011","11110100","11110111","10101100","10100100","10100011","10100100","10100011","10100011","10011011","01010010","01011011","01010010","01010010","01011011","01001010","01001001","01010001","01010010","01011010","01010010","01010010","01010010","01010010",
"01010010","10011011","10101100","01011011","10100011","10101100","11100011","10100100","10100100","10100100","10100100","10100011","10011011","01011011","01011010","01010010","00001010","01001001","01010011","01011010","01011010","01011011","01011010","01010011","01010001","00001010","01001001","00001010","01001010","01010010","10011011","11110111",
"10101100","10101100","11110111","11110111","11110111","11101100","10101100","10100011","11110111","11110111","10101100","10101011","10100100","10100100","10100011","10011011","10011011","01011011","01011010","01011010","01010010","01011010","01010011","01001001","00001010","01001010","01001010","01001001","01001010","01001001","00010010","01010010",
"10100100","11110100","10011011","10100100","11101101","10101100","10100100","10100011","10100011","10100100","10100011","10011011","01011011","01011011","01011010","01001010","01001001","00001010","01010010","10011010","01011011","01011010","01010010","01010001","01001010","01001001","00001010","01001001","01010010","10011011","10101100","10100011",
"10101100","10101100","11110111","11110100","11101100","10100011","10100011","10100100","10101100","10101011","10100100","10100100","10100011","10100011","10011011","10011011","01011011","01011010","01011010","01010010","01011011","01010010","01010010","00001010","01001001","01010010","00001010","00001010","01001001","00010010","01010011","10100100",
"11110111","10100011","10100100","10101100","11110111","10100011","10100100","10011011","10011011","10011011","10011011","01010011","01011010","01011010","01010010","00001010","01001001","00001010","01010001","01011011","01010011","01011010","01001010","00001010","01001010","01001001","00001010","00010010","01011011","10100011","10100011","10101100",
"10101100","11110111","10110100","10100100","10100011","10100100","10100011","10100100","11101100","10100100","10100100","01011011","10011011","10011011","10011011","01011010","01011011","01011011","01011010","01010011","01010010","01011011","01010001","01001010","00001010","00000000","01000001","01001010","00010010","01011010","10100011","10100100",
"11110111","10101100","10101100","11110111","10101100","10100100","10100011","01010011","01011010","10011011","01011011","01011010","01011011","01010010","00001010","00001010","01001010","01001001","01001010","01001001","01001010","00001010","00001010","01001001","01001001","00001010","01001001","01011010","10100011","10100011","10101100","10100011",
"10101100","11110111","10100100","10100100","10100011","10100100","11100100","10101100","10100011","01011011","10011011","10011011","10011011","01011011","01011010","01011010","01011010","01011010","01010010","01010010","01010011","01010010","00001010","00001010","01001001","01001001","00010001","00001010","01011011","10011011","10100100","11110111",
"10101100","10101100","10101100","10101100","10100100","10100100","10100011","01011010","01011011","01011011","01011010","01011010","01010010","00001010","01001010","01010001","01010010","01010011","01010010","01001001","00001010","00001010","01001001","00001010","01000001","01001010","01010010","10100011","10011011","10011011","10100011","10100100",
"10101100","10100100","10101011","01100011","10100011","10100100","10100011","01011011","10011011","10011011","10011011","01011011","01011010","01011011","10011011","01011010","01010010","01011010","01010010","01010010","01010010","01001001","00001010","01001001","01001010","00001010","00001010","01010010","01011010","10100100","10100101","11110111",
"10101100","10101100","10101100","10011011","10101100","10100011","10100011","01010010","01011011","01011010","01011010","01010011","01001001","01001001","00010010","01011010","10100011","10100011","10100011","01011010","00001010","01001001","00001010","00010001","00001010","01010001","01011011","10100011","01011011","01011011","10100100","10101100",
"10100100","10101100","10011011","10011011","10011011","10011011","10011011","10011011","10100011","01011011","01011010","01011011","01011011","10011010","01011010","01010010","01010010","01011010","01010011","01010010","01001010","00010010","01010010","01011100","01011010","01001001","01001010","01001010","01010010","10101100","11110100","10101100",
"10100100","11110111","10101100","10100011","10100100","10100100","10011011","01011010","01011010","01011011","01010011","01001001","00001010","01010010","01010010","10101100","10100100","10100011","10100011","10011011","01010010","00001010","01001001","01000001","00001010","01010011","10100011","10011011","01011011","10101011","10101100","10101100",
"10100100","10011011","10100011","10011011","10011011","10100011","01011011","01011011","01011010","01011011","01011010","01011010","01011010","01011010","01010010","01010010","01011011","01010010","01010001","01010010","00001010","10011011","10100100","10100011","01011011","01010001","00001010","01010010","10011011","10100011","10110100","11100100",
"10101100","11101100","10101100","10100011","10100100","10100011","01011010","01011010","10011011","01010010","01010010","01010001","01010010","01010010","10100011","11110111","10101011","11100100","10100100","01010011","01011011","01001001","00001010","00001010","01010001","01011011","10100011","01010010","10100011","11110111","10100100","10100011",
"11100100","10100100","10011011","10011011","01011011","01011011","01011010","10011011","01011010","01011011","01011010","01010011","01010010","01010010","01010011","01010011","01011010","01001001","01001010","01001001","10100011","11110111","10100011","11110111","01011011","01010010","01001001","01010010","10100011","10100100","11110111","10101100",
"11110111","10101100","10100011","10100100","01100011","10011011","01011010","01011010","01011010","01010010","01010001","01001010","01010011","01011010","11110111","10101100","10101100","10100100","10011011","01011011","01011010","01010010","00001010","01001010","00001010","10100100","01011010","10011011","10100011","10101100","11110111","10100100",
"10101100","10100011","01010010","01011011","01011010","01011010","01011011","01011010","01010010","01010010","01010011","01010010","01010011","01011011","01010010","01010010","00001010","01001010","00010001","10011100","11110101","10100100","10101100","01011011","01011010","01010011","00001010","01011010","10100100","10101100","10101100","10101100",
"11110111","11110111","10100100","10100011","10011011","10011011","01011010","01010010","01010011","01010010","01001010","00010010","01010010","10100011","10101100","11110111","10101100","10100100","01011011","01011011","01011010","01010010","00001010","01001001","01010010","10100011","01010011","10100011","10100011","11110111","11110111","10101100",
"10011011","01010011","01011010","01011011","01011010","01011010","01011010","01010010","01010010","01011011","01010010","01010011","01011010","01010010","01001010","00001010","00001010","01001010","01010010","11110100","10100100","10101100","10100011","10011011","01011010","01010011","00010010","01011010","11101100","10100100","10101011","10101100",
"11110111","11110111","10100011","10100100","10011011","01011011","01011010","01010010","01011010","01001010","01010010","01010010","10100100","10101100","10101100","10101100","10100100","10011011","01011010","01011010","01010010","01010011","01001001","00010010","10011011","01010010","10011011","10100100","11110111","11110111","10101100","10100100",
"10100011","10100011","10011011","10100011","01011010","01011011","01010010","01010010","01010011","01010010","01010011","01010010","01001001","01001010","00001010","01001001","00001010","00010001","10100101","10100011","10101100","01011011","01011010","01011011","10011011","01010010","01001010","10011011","10101100","10100011","10101100","10101100",
"11110111","10100100","10100011","10100011","10011011","01011011","01011010","01010010","01010011","01001001","01010010","11110111","10101100","10101100","10101100","10100100","10100011","01011011","01011010","01011010","01010011","01010010","00001010","01010010","01011011","10011011","10100011","11101101","10101100","10101100","10100100","10011011",
"10100100","10100100","10011011","01010010","01011011","01011011","01010010","01010011","01010010","01010010","01010010","00001010","01001010","00001010","00000000","00010010","01001010","01001010","11110111","10100011","10101100","01011011","01011011","01011011","01011010","00001010","01010010","10100011","10100011","10100100","10101100","10100101",
"11110111","10101011","10100100","10100011","01010011","01011011","01010010","01010011","01010001","00010010","10011011","11110111","10101100","10101100","10101100","10011011","01011011","01011011","01011010","01011010","01011010","01010010","01001001","01011011","01010010","10101100","10101100","10101100","10101100","10101100","10100011","10100100",
"10100100","10100011","01010010","01011011","10011010","01011010","01010011","01010010","01010001","01001010","00001010","01001001","00001010","01001001","00010001","01001010","00001010","01011010","11110101","10100011","10100100","01011011","01011010","01011011","01010011","01001001","01010010","10100011","10100100","10101100","10101100","11101100",
"11110111","10100100","10100100","10100011","01011011","01011010","01010010","01010010","01010010","01001001","10100011","10101100","11110111","10101100","10100011","10100100","10100100","10011011","01011011","01011010","01010011","01001010","01010010","01011011","10100011","11110111","10100011","10101100","11110111","11110111","11110111","10101011",
"10100011","01011011","01011010","01011011","01011010","01010010","01010010","00001010","00001010","00001010","01001001","00001010","00001010","00001010","00000000","00001010","01010001","10011011","11110101","10100011","10101100","01010011","01011010","01011010","01010010","00010001","10100100","01011011","10100100","10101100","10101100","11110111",
"10101100","10101100","10100011","10100011","01010010","01011011","01010010","01010010","01001001","01010010","10100100","10101100","10101100","10101100","10101100","10100100","10100100","01011011","01011010","01011010","01010010","00010001","10011011","01011011","11100100","11110111","10100100","10100011","10100100","10101100","11101101","10100011",
"01011011","01011011","10011010","01011010","01010010","01010010","00001010","00001010","00001010","01001010","01001001","01001001","00001010","00000000","00001010","00001010","00010001","10100100","11110111","10100011","10101100","01010010","01011011","01011011","01001001","01010011","10011010","01100011","11100100","10101100","10101100","11110100",
"11110111","10100011","10100100","10100011","01011011","01010010","01011011","01010001","01010010","01010010","10011011","11100100","10100100","10101100","10101100","11100100","10011011","01010010","01011011","01011010","01001001","00010011","10011011","10100011","11110111","10101100","10100100","10100100","10100100","10100100","10100011","10100011",
"01011010","01011010","01011010","01010011","01001010","00001010","01010010","01010011","01010001","01001010","00001010","00001010","01001001","00010010","01001001","00001010","00001010","10101100","11110111","10101100","10100011","01011010","01011010","01001010","00010010","01011010","01011011","10100100","10101100","10101100","10101100","11110111",
"10101100","10100100","10100011","01011011","01011011","01011010","01010010","01001010","00001010","01010010","01011011","10100100","10100011","11100100","11110111","10101100","01011011","01011011","01011010","01010011","00010001","01010010","01011011","11100100","11110111","10100011","10101100","10011011","10100011","10100100","10011011","01010011",
"01011010","01010011","01010010","00001010","01010010","11110111","10100011","01011010","01010011","01001001","00001010","00010001","01001010","01001001","01001010","00001010","00001010","10101100","10100100","10100100","10011011","01011011","01010011","00010001","01010010","01010011","10100011","10101100","10101100","10101100","10101100","10101100",
"10100100","10100100","10011011","01011011","01011010","01010010","01010010","00001010","00001010","01001010","01010010","01011010","10011011","10100011","10100100","10100011","01011011","01011010","01010011","01010001","00001010","01011010","10100011","11110111","11110111","10100100","10011100","10011011","10011011","10011011","01011011","01011010",
"01010011","01010010","00001010","10011011","11110111","10101100","10011011","01010010","01010010","00001010","01001010","01010010","01010010","01010011","01010010","01011010","00001010","11110111","10101100","10100011","01010011","01011010","01010001","00010010","01010010","10100011","10101100","10101100","10101100","10100011","10101100","10101100",
"10100100","10100011","01011011","01011010","01011010","01011011","00001010","00001010","01000001","00001010","01001001","01010010","01011010","01011011","11110111","10011011","01011010","01011010","01010011","01010010","01010001","01011011","11101011","11110111","10100011","10100011","10011011","01010010","01011011","01011010","10011011","01011010",
"01010010","00001010","10011011","11110111","10100100","10011011","01011010","01010010","00001010","01010011","01011010","01010011","10011011","10011011","01011011","01011010","01001001","10101100","10100011","10011011","01011011","01010011","00001010","01010010","10100011","11110111","10101100","11110111","10100011","10100100","10101100","10100100",
"10100011","10011011","01011010","01011011","01011011","01001001","00001010","00000000","00001010","00000000","00001010","01001001","01010011","01011010","10011011","01011011","01011010","01010010","01010010","01001010","01010010","10100011","11110111","10101100","10100100","01011011","10011011","01011010","01011011","01011010","01011010","01010010",
"00001010","10100100","11110111","10100100","10100011","01011010","01001010","01010010","01010010","01011011","10100100","11110111","11110111","10100011","01011011","01011011","00010001","10100100","10011011","01011010","01010010","01001001","01001010","10011011","11110111","10101100","10101100","10100011","10100100","10100100","10100100","10100100",
"10011011","10011011","01011010","01011011","01010010","00001010","01001001","00001010","01001010","01001010","01001010","01001010","01010001","01011010","01011011","01011011","01011010","01010011","01001010","01010001","01010010","10101100","11101101","10100100","10100011","10011011","01011011","01011011","01011010","01011010","01010011","01010010",
"10011011","11110111","10101100","01011011","01011010","01001010","01010010","01010011","10101100","11101101","10110101","11101100","10101100","10100011","01011011","01011010","00001010","10011011","01011010","01010010","01010010","00001010","01011010","10101100","10101100","10100100","10100011","10100100","10100011","10100100","10100011","10011011",
"10011011","01011011","01011010","01010011","01001001","00001010","00010001","01001010","00010010","01010011","01011010","01001001","01001001","01010011","01011010","01011010","01010010","01010010","01010001","01001001","01011011","11100100","10101011","10100100","10100011","10011011","01011010","01011011","10011010","01010010","01011010","01001010",
"10101100","10100011","01010011","01010010","01010010","01010010","10100011","11110111","11110111","10101100","11101100","10100100","10100011","10011011","01011010","01011010","01010010","00001010","01010010","01001001","00001010","01001010","10100100","11100100","10100100","10100011","10100100","10011011","10011011","10011011","10011011","10011011",
"01011011","01011010","01010010","01010001","00001010","00001010","01001010","01010010","01011010","10100011","01011010","01010010","01010010","01010010","01010011","01011010","01010011","01010001","01001010","01001001","01011011","10101100","10100100","10100011","10100011","01100011","01011011","01011010","01010010","01010011","00001010","01011010",
"10100100","01011010","01010010","01001010","01011010","10100100","11110111","11110100","11101100","10101100","10100100","10100011","10011011","10011011","01011011","01011010","01010010","00001010","00001010","00001010","00001010","01011011","11110111","10101100","10100011","10100011","10011011","01011010","01010011","10011011","01011011","01011011",
"01011010","01010010","01001001","01001010","01001001","01010010","01010010","01011010","10100100","10100100","01011011","00010001","01010010","01001001","01010010","01010010","01010010","01001010","00001010","01001010","10100011","10100100","10100100","10100100","10011011","01010010","01011011","01011010","01010011","00010001","01001010","10100011",
"01011010","01001010","01010010","01011010","10100100","10101100","11110111","10101100","10100011","10011100","01011011","10100011","10011011","10011010","01011010","01011011","01010001","01001001","00001010","00001010","01001001","10100100","10101100","10100011","10011011","10011011","01011011","01011010","01011011","01011011","01011010","01011010",
"01010010","01001010","01001001","00001010","01010011","01011010","01011011","10101100","11110111","10011011","01011010","01010011","01001001","01010010","01001001","01010010","01010010","00001010","00001010","01001001","01011011","10101100","10101100","10100011","10011011","01011011","01011010","01010011","00001010","01010010","01011011","01100011",
"00001010","01010011","01010010","10100011","11110111","11110111","10100011","10101100","10100100","10101100","10100011","10011011","10011011","10011011","01011010","01011010","01010010","00001010","01001001","00001010","01010010","11110111","10100011","10011011","10011011","01010010","01011011","01011011","10011010","01011010","01011011","01010010",
"01001001","01001001","00001010","01011011","10011011","01011011","10100100","10101100","10100100","10100011","01011010","01010010","00001010","00001010","01010010","01001001","00001010","00001010","01001001","01001010","01011010","10011011","10011011","10011011","01011011","01011010","01010011","00010001","01001010","01010010","01011010","01010010",
"01010010","01010010","10011011","11110111","10101100","10100100","11110111","11110111","10100011","10100100","01100011","10011011","10011011","01100011","01011011","01010010","01010010","00010001","00001010","01001001","01011010","10101100","10100011","10011011","01011011","10011011","01011010","01011010","01011011","01010010","01010010","01001001",
"00001010","01001010","10101011","10100011","01011011","11100100","11110100","10101100","10100011","10011011","01011011","01010010","01001010","00000000","01001010","01010010","01001010","01001010","00010001","01001010","01010011","01011010","01011011","01011011","01011010","01010011","01010001","01001010","00001010","01010010","01001010","01001001",
"01010010","01010010","11101100","10101100","11110111","10101100","11110100","10100100","10101100","10100011","10011011","10011011","10100011","01010010","01011011","01010011","01001001","01001001","00001010","01001001","10100011","10101100","10011011","01010011","01011010","01011010","01011010","01010011","01010010","01001010","01001001","00001010",
"01010010","10101100","10100100","10100100","10100011","11110100","11110111","10100011","10100100","01100011","10011010","01010010","00001010","00001010","01001001","01010010","00001010","00010010","01001010","01001001","01010010","01011010","01011010","01011011","01010010","01010001","00001010","01001001","00001010","00001010","01001001","01011011",
"01010010","10101100","11110111","11110111","11110111","11110111","10100100","10101100","10011011","10011011","10011011","01011011","01011010","01011011","01011010","01010001","00001010","00001010","01001001","00010001","10100011","10011011","01010010","10011011","01011010","01010011","01010010","01010001","01001010","01001001","01001001","01010010",
"11110111","11110111","11110111","10101011","11110111","11110111","10100100","10100100","01100011","01010011","01011011","01010010","00001010","01010010","00001010","01011010","10011011","01011011","01010010","01001010","01001010","01011011","01010011","01010001","01001010","00001010","01001001","01001001","00001010","01001010","00010010","01011010",
"01100011","11110111","10101100","11110111","11110111","10100011","10100100","10100011","10011011","01011010","01011010","01011011","10011011","01011010","01010010","00001010","01010010","01010010","00001010","01010001","01011011","01011011","10011010","01011010","01010011","01010010","01001001","01001010","00001010","01001001","01010010","10101100",
"11110111","11101100","10101100","11110111","11110100","10101100","10100100","10100011","10011011","01011010","01011010","01010001","01001010","00001010","01011011","10100100","11110111","11110111","10100011","01011010","01001001","01001001","01010001","01001010","00001010","00001010","00000000","00001010","01001010","01010010","01011010","01011010",
"10100011","11110111","11110111","11101100","10100100","10100100","10100011","10011011","01011010","01011011","01011010","01011010","01011010","01010010","00001010","01011011","10100011","01011011","01010010","00010010","10011011","01011010","01011010","01010010","00001010","01010010","01001010","00001010","01001001","01010010","10101100","11110111",
"11110111","10101100","10101011","10101100","10101100","10100011","10101100","10100011","01011011","01011010","01011011","01001001","01001001","01010010","10011011","11110111","10101100","10101100","10101101","10011011","01010011","01001001","00001010","01001001","00001010","01001001","01001001","00001010","01010001","01010010","10011011","01011011",
"10101100","11110111","10101100","10101011","10100100","10100011","10011011","01011010","01010011","01011011","01011010","01010011","01010010","00001010","01010010","10101100","11110111","10100011","01011011","01001010","00010001","01010010","01001010","00001010","01001010","00001010","00001010","01001010","01010011","10011010","11101101","11110100",
"10100100","10101100","10100100","10101011","10101100","10100100","10100011","10011011","01011011","01011011","01010010","01001010","01010001","01011011","10101100","10101100","10101100","10101100","10101100","10101100","01011011","01010010","01001010","00001010","00001010","01001001","00001010","01001001","01010010","10011011","01011011","10101100",
"11110111","10100100","10101011","10100100","10100011","10011011","10011011","10011011","10100011","01010011","01011011","01011010","01010011","00001010","01010011","11110111","11110111","10101011","10100011","01011010","01001001","00001010","01001001","01001001","00001010","00001010","01001010","01010010","01010010","10101100","11110111","10100100",
"11110111","10101100","10100011","10100100","10100100","10101100","01011011","10100011","01010011","01011010","00010010","01001001","00001010","10100011","11110111","10101100","10101100","11110111","10101100","10100100","10011011","01011010","01010001","00001010","01000001","00001010","01001001","00010010","01011011","10100011","10100011","11110111",
"10101100","10101100","10100100","10100011","10100011","10011011","10011011","10100011","10011011","10100011","01011010","10010011","01010010","00001010","10011011","11101100","10110100","10101100","10100100","10011011","01011011","01001001","00001010","01001001","01000001","01001010","00010010","01011010","01011011","11110101","11101100","11110111",
"10101011","11110111","10100100","01011011","10100011","10100011","10011011","01010011","01011011","01011010","01001001","01001010","01010010","10100100","11110111","11110111","10100100","10100011","10101100","10100011","10011011","01011010","01010010","00001010","01001001","00001010","01010010","01010010","11100100","10011011","11100100","11110111",
"10101011","10100100","10100100","10011011","10011011","01011011","11101100","11110111","01100011","10011011","01011011","01011010","01011011","01001001","10011011","10100100","10101100","10101100","11100100","10100100","01011011","01011011","01001010","01001001","00001010","00010010","01011010","10011010","10100100","11110100","10100100","11110111",
"10100100","10101100","10101100","10011011","01011011","01010010","01011011","01011011","01011010","01010010","00001010","01010001","01011011","11110111","11110111","11101101","10101011","10011011","01011011","01010010","01011010","01010010","01011011","01001001","00001010","01001001","01010010","10100100","10100011","10100100","10110100","11110111",
"10100100","11100011","10100100","10100100","10100100","10100100","10101100","10100100","10011011","10011011","01011011","01011010","01011010","00001010","01100011","10101100","10100100","10101100","10100100","01011011","01011010","01010011","01010001","00001010","01010010","01010010","01011011","10011011","11110111","10100100","11110111","10100100",
"10101100","10101100","10100011","10011011","01011011","01011010","01011011","01011010","01010011","01001001","01001010","00010010","10011011","11110111","11110111","11110111","10101100","10100011","01011011","01011010","01010010","01010010","01010010","00001010","01001010","01010010","01011010","11110111","10100011","10101100","11110111","10101100",
"10100011","10101100","10100011","10101011","10101100","10101100","11100100","10100011","10100011","10011011","10100011","01011011","01010010","01010010","01011010","10011011","10011011","01010011","01011010","01011010","01010010","01010010","00001010","00001010","10011011","01011011","11101100","10100011","11101101","10101011","10101100","10101100",
"10101100","10100011","01011011","01011010","01011011","01011011","01011010","01011011","01001001","00001010","01001001","01011010","10100100","11110111","11110111","11110111","11110111","10100011","10011011","01011011","01010010","01010011","01010001","00001010","01010001","00010010","10100100","10100011","10101100","10101100","11110111","10100011",
"10101100","10101100","10101100","11110111","10101100","10100100","10100011","01100011","10011011","10011011","01011011","01011010","01010011","01010010","01001010","01011010","01011011","01011010","01010010","01010010","00001010","00001010","01001001","01011011","10100011","10101100","11110111","10101100","10101100","10100011","10101100","10101100",
"10100100","01011100","10011011","01011011","01011010","01011010","01010011","01010001","00001010","01001001","00010010","10011011","11110111","11110111","11110111","11110111","10100011","10011011","10100011","01011010","01010011","01010010","01001001","01001001","01010010","10011011","11110111","10101011","10101100","10101100","11110111","10100011",
"10100100","10101100","11110111","11110111","10101100","10100100","10100011","10011011","10011011","10011011","01011011","01011010","01010011","01010001","01001001","01010010","01010010","01001001","00001010","01010010","00001010","00001010","01001010","10100100","10100011","11110111","10110100","10101100","10100100","10100100","10101100","10101100",
"10100011","10011011","01011011","01011010","01011010","01010010","01011010","00001010","01001001","00001010","01010010","10101100","11110111","11110111","11110111","10100011","10011011","10011011","01011010","01010011","01011010","01001001","00001010","01010010","01010011","10101100","10100011","11110111","10100100","11110111","10101100","10101100",
"10100011","11110111","11110111","10101100","10100100","10100100","10011011","10011011","10011011","01011011","01011010","01010010","01011010","01001010","00001010","00001010","01001001","01001001","01011011","10011011","01001001","01001010","01010010","10101100","10101100","11110111","11110100","10100100","10100011","10100011","10101100","10100011",
"01100011","10011011","01011010","01011011","01010010","01011011","01001001","01001001","00001010","00001010","01010010","11110100","11110111","10100011","10100011","10011011","10011011","01011010","01010011","01011010","01001001","00010010","01010010","01010010","10100011","10101100","10110101","11100100","10101100","11110111","10101100","10101100",
"10101100","10101100","10101100","10100100","10100011","01011011","10011011","10011011","10011011","01011010","01011011","01010010","01010010","00001010","00000000","01001001","00010010","11110111","11110111","10011011","01010001","00001010","01010010","11101100","11110111","11110111","10101100","10100100","10100011","10100100","10100100","10100011",
"10011011","01011011","01011011","01010010","01010011","01010001","00001010","00001010","01001001","00001010","10011011","10100011","10100100","10100011","10011011","01011010","01011010","01010011","01010010","00010001","01001010","01001001","01010010","10011011","10100100","11110111","11110111","10100100","11110111","11110111","10101100","10100100",
"10101100","10101011","10100100","10101100","01100011","10011011","10011011","10011011","01010010","01011011","01010010","01011011","00001010","01001001","00001010","01010011","11110100","10101100","10101100","10011011","01010010","01001001","01010010","10100100","10101100","11110111","11110111","10101011","10101100","10011011","01100011","10011011",
"10100011","01011011","01011010","01010011","01010001","00001010","01001001","00000000","01010010","00001010","01011010","10011011","10011011","01011011","01011010","01010010","01010011","01010010","01010010","01001010","01001001","00010010","10011011","10100011","11110111","10101100","11110111","10101100","11110111","11110111","10101100","10100011",
"10100100","10100100","10100011","01011011","10011011","10011011","10011011","10100011","01011010","01011010","01010011","01010001","00001010","00001010","10100011","11110101","10101100","10100011","10101100","10011011","01010010","01001010","01010010","10011011","11110111","10101100","10101011","10100100","10101100","10011011","10011011","10011011",
"01010011","01011010","01010011","01010010","00001010","00001010","01001001","00001010","01001001","00001010","01010010","01011010","01010010","01010010","01010011","01010010","01010001","01010010","01010001","00001010","00001010","01010010","10101100","10100100","11110111","11110111","11100100","10101100","11110111","11101100","10101100","10100100",
"10011011","01011011","10011011","10011011","10100011","10011011","10011011","01011010","01011011","01010010","01010011","00001010","01001001","01011011","11110111","10101100","10100100","10100100","10101100","01011011","01010011","01001001","00010010","10011011","10100100","11101100","10100100","10101100","10100011","10100011","01010010","01100011",
"01011011","01011010","01010010","00001010","01001001","00001010","01001001","00000000","01001001","00001010","01001001","01010011","01010011","01010010","00010010","01010001","01001010","01010010","00001010","00001010","01001010","10100011","11100100","10100011","11110111","11100100","10101100","10101100","11110111","11110111","10100011","10100011",
"10011011","10011011","10100011","10011011","10011011","10011011","01011010","01011011","01011010","01010011","00001010","01001010","01010010","10100100","10101011","10100100","10100011","01011011","10100011","01011010","01010010","00001010","01010010","01011010","10100011","10100011","10100100","01100011","10011011","01010011","01011011","01011010",
"01011010","01010011","01001001","00001010","01001001","00010001","00001010","01001010","00001010","00001010","00001010","01010010","01010001","01001010","01010001","01001010","00001010","01001010","01001001","00001010","01010010","10101100","10101100","10101100","10101100","10101100","10100011","10101100","10101100","10101100","10100100","01011011");

  -- Signals for the video controller
  signal Hcount : unsigned (9 downto 0);  -- TOTAL Horizontal position 
  signal Vcount : unsigned (9 downto 0);  -- TOTAL Vertical position 
  signal HcountR: integer;  -- Real Horizontal position (0-800)
  signal VcountR: integer;  -- Real Vertical position (0-524)
  signal EndOfLine, EndOfField : std_logic;

  signal vga_hblank, vga_hsync, vga_vblank, vga_vsync : std_logic;  -- Sync. signals	

  signal Hextra: integer := 0;
  signal Vextra: integer := 0;

  -- Internmediate signals
  signal sprite_map		: sp_map;
  signal sprite_buffer 	: buf;
  signal show_spriteTile: std_logic				:= '0' ;
  signal show_something : std_logic				:= '0' ;
  signal sprite_pointer : unsigned (2  downto 0):= TO_UNSIGNED(0,3);
  signal sprites_2_show	: unsigned (15 downto 0):= TO_UNSIGNED(0,16);--
  signal sprites_copied : unsigned (15 downto 0):= TO_UNSIGNED(0,16);--
  signal sp_pointer     : unsigned (12 downto 0):= TO_UNSIGNED(0,13);
  signal buffer_pointer : unsigned (6  downto 0):= TO_UNSIGNED(0,7);
  signal en_sprite 		: std_logic				:= '0';
  signal en_sprite1 	: std_logic				:= '0';
  signal buffer_pointer1: unsigned (6  downto 0):= TO_UNSIGNED(0,7);
  signal cop_sprite		: unsigned (31 downto 0):= TO_UNSIGNED(0,32);

  signal tile_pixel_h   : unsigned (6 downto 0) := TO_UNSIGNED(0,7);
  signal tile_pixel_v   : unsigned (6 downto 0) := TO_UNSIGNED(0,7);
  signal tile_pixel		: unsigned (7 downto 0) := TO_UNSIGNED(0,8);
  signal tl_pointer     : integer;

  signal transparency   : ram_type;
  signal tranCounter 	: unsigned (9 downto 0):=TO_UNSIGNED(0,10);
  signal old_transparency:unsigned (9 downto 0);--no default needed  					

  signal color_2_show   : unsigned (7 downto 0):=TO_UNSIGNED(0,8);
  signal colorInternal  : std_logic_vector (31 downto 0):=std_logic_vector(TO_UNSIGNED(0,32));
					
  signal random			: unsigned (31 downto 0):= TO_UNSIGNED(0,32);
  									  
  signal clk25 			: std_logic := '0';	 -- 25 MHz clock

  signal VGA_R_IN		: std_logic_vector(9 downto 0);-- Red[9:0]
  signal VGA_G_IN		: std_logic_vector(9 downto 0);-- Green[9:0]
  signal VGA_B_IN 	    : std_logic_vector(9 downto 0);-- Blue[9:0]

  signal Y				: std_logic_vector(7 downto 0);
  signal Cb				: std_logic_vector(7 downto 0);
  signal Cr				: std_logic_vector(7 downto 0);

  component itu_r656_decoder
  port(	CLOCK,TD_HS,TD_VS	: in std_logic;
		TD_D : in std_logic_vector(7 downto 0);
		Y,Cb,Cr	: out std_logic_vector(7 downto 0);
		R,G,B 	: out std_logic_vector(9 downto 0));
  end component;

  component YCbCr2RGB
  port( iY,iCb,iCr : in std_logic_vector(7 downto 0);
		iRESET,iCLK : in std_logic;
		Red,Green,Blue 	: out std_logic_vector(9 downto 0));
  end component;

begin
  --to avoid warnings
  LEDR <= (others => '0');

  -- CLK conversion
  ClkConver : process (clk)	--create a PLL with a megafunction
  begin
    if rising_edge(clk) then
      clk25 <= not clk25;
    end if;
  end process ClkConver;
--
--  PLL to create a 25 MHz clock
--  ClkPLL : entity work.pll
--		   port map(inclk0=>clk, c0=>clk25);
  --Color table
--  Color : entity work.colors_rom
--		  port map(address=>std_logic_vector(color_2_show),clock=>clk25,q=>colorInternal);

  --Decoder : itu_r656_decoder port map(CLOCK=>clk25, TD_D=>TD_DATA, TD_HS=>TD_HS, TD_VS=>TD_VS, Y=>Y, Cb=>Cb, Cr=>Cr, R=>VGA_R_IN, G=>VGA_G_IN, B=>VGA_B_IN);
			
  --Conver : YCbCr2RGB port map(Red=>VGA_R_IN, Green=>VGA_G_IN, Blue=>VGA_B_IN, iY=>Y, iCb=>Cb, iCr=>Cr, iRESET =>'0', iCLK=>clk25);

  --random numbers generator
  RandomGenerator : process (clk)
  begin
	if rising_edge(clk)then
	  if random = TO_UNSIGNED(255,32) then
	    random <= (others => '0');
	  else
		random <= random + 1;
	  end if;
	end if;
  end process RandomGenerator;  

  -- Horizontal and vertical counters
  HCounter : process (clk25)
  begin
    if rising_edge(clk25) then      
      if reset = '1' then
        Hcount  <= (others => '0');
		HcountR <= -1;
      elsif EndOfLine = '1' then
        Hcount  <= (others => '0');
		HcountR <= -1;
      else
        Hcount <= Hcount + 1;
		if Hcount >= HSYNC + HBACK_PORCH - 2 then --change to 0 two cycles before than vga_hblank => '0'
		  HcountR <= HcountR + 1;
		end if;
      end if;      
    end if;
  end process HCounter;

  EndOfLine <= '1' when Hcount = HTOTAL - 1 else '0';
  
  VCounter: process (clk25)
  begin
    if rising_edge(clk25) then      
      if reset = '1' then
        Vcount <= (others => '0');
		VcountR <= -1;
      elsif EndOfLine = '1' then
        if EndOfField = '1' then
          Vcount  <= (others => '0');
		  VcountR <= -1;
        else
          Vcount <= Vcount + 1;		
		  if Vcount >= VSYNC + VBACK_PORCH - 1 then	--same cycle than vga_vblank => '0'
			VcountR <= VcountR + 1;
		  end if;	
        end if;
      end if;
    end if;
  end process VCounter;

  EndOfField <= '1' when Vcount = VTOTAL - 1 else '0';

  -- State machines to generate HSYNC, VSYNC, HBLANK, and VBLANK
  HSyncGen : process (clk25)
  begin
    if rising_edge(clk25) then     
      if reset = '1' or EndOfLine = '1' then
        vga_hsync <= '1';
      elsif Hcount = HSYNC - 1 then
        vga_hsync <= '0';
      end if;
    end if;
  end process HSyncGen;
  
  HBlankGen : process (clk25)
  begin
    if rising_edge(clk25) then
      if reset = '1' then
        vga_hblank <= '1';
      elsif Hcount = HSYNC + HBACK_PORCH then	
        vga_hblank <= '0';	--executed in the cycle 144, visible in the 145
      elsif Hcount = HSYNC + HBACK_PORCH + HACTIVE then  
        vga_hblank <= '1';
      end if;      
    end if;
  end process HBlankGen;

  VSyncGen : process (clk25)
  begin
    if rising_edge(clk25) then
      if reset = '1' then
        vga_vsync <= '1';
      elsif EndOfLine ='1' then
        if EndOfField = '1' then
          vga_vsync <= '1';
        elsif Vcount = VSYNC - 1 then
          vga_vsync <= '0';
        end if;
      end if;      
    end if;
  end process VSyncGen;

  VBlankGen : process (clk25)
  begin
    if rising_edge(clk25) then    
      if reset = '1' then
        vga_vblank <= '1';
      elsif EndOfLine = '1' then
        if Vcount = VSYNC + VBACK_PORCH - 1 then
          vga_vblank <= '0';
        elsif Vcount = VSYNC + VBACK_PORCH + VACTIVE - 1 then
          vga_vblank <= '1';
        end if;
      end if;
    end if;
  end process VBlankGen;

							--	 [31	   27|   26	  |25 16|15  6|5        1|     0 	   ]
  --sprites from the SW, format: [SpriteID(5)|shown(1)|H(10)|V(10)|sprite#(5)|spriteFlip(1)]

  SpriteGen : process (clk25)
  begin
	if rising_edge(clk25) then 
	  L0: for c in 0 to 15 loop
		if sprite_map(c)(26)='1' and VcountR>=(TO_INTEGER(sprite_map(c)(15 downto 6))-Vextra) and VcountR<(TO_INTEGER(sprite_map(c)(15 downto 6))+VSPRITE-Vextra)then
		  sprites_2_show(c) <= '1';
		else 
		  sprites_2_show(c) <= '0';
		end if;
	  end loop L0;
	
	  if VcountR>=0 and VcountR<VACTIVE  and Hcount=TO_UNSIGNED(0,10) then	--Cycle 0
		sprites_copied  <= (others => '0');
		sprite_pointer  <= "000";		  	
	  end if;
		
	  if VcountR>=0 and VcountR<VACTIVE  and Hcount>TO_UNSIGNED(0,10) and Hcount<TO_UNSIGNED(129,10) then	--Cycle 1-128: copy the row of the sprites thaat are shown to buffers
		if sprites_2_show(0)='1' and sprites_copied(0)='0' then							
		  buffer_pointer	<= TO_UNSIGNED(8*0,7) + sprite_pointer;
		  sp_pointer	   	<= TO_UNSIGNED(256*TO_INTEGER(sprite_map(0)(5 downto 1)),13) + TO_UNSIGNED(8*(VcountR-TO_INTEGER(sprite_map(0)(15 downto 6))+Vextra),13) + sprite_pointer;
		  en_sprite 	   	<= '1';	 
			
		  if sprite_pointer = "111" then --review
			sprite_pointer <= "000";			  
			sprites_copied(0) <= '1';
		  else
			sprite_pointer <= sprite_pointer+1;
		  end if;
		elsif sprites_2_show(1)='1' and sprites_copied(1)='0' then
		  buffer_pointer	<= TO_UNSIGNED(8*1,7) + sprite_pointer;
		  sp_pointer	   	<= TO_UNSIGNED(256*TO_INTEGER(sprite_map(1)(5 downto 1)),13) + TO_UNSIGNED(8*(VcountR-TO_INTEGER(sprite_map(1)(15 downto 6))+Vextra),13) + sprite_pointer;
		  en_sprite 	   	<= '1';	 
			
		  if sprite_pointer = "111" then --review
			sprite_pointer <= "000";			  
			sprites_copied(1) <= '1';
		  else
			sprite_pointer <= sprite_pointer+1;
		  end if;
		elsif sprites_2_show(2)='1' and sprites_copied(2)='0' then
		  buffer_pointer	<= TO_UNSIGNED(8*2,7) + sprite_pointer;
		  sp_pointer	   	<= TO_UNSIGNED(256*TO_INTEGER(sprite_map(2)(5 downto 1)),13) + TO_UNSIGNED(8*(VcountR-TO_INTEGER(sprite_map(2)(15 downto 6))+Vextra),13) + sprite_pointer;
		  en_sprite 	   	<= '1';	 
			
		  if sprite_pointer = "111" then --review
			sprite_pointer <= "000";			  
			sprites_copied(2) <= '1';
		  else
			sprite_pointer <= sprite_pointer+1;
		  end if;
		elsif sprites_2_show(3)='1' and sprites_copied(3)='0' then
		  buffer_pointer	<= TO_UNSIGNED(8*3,7) + sprite_pointer;
		  sp_pointer	   	<= TO_UNSIGNED(256*TO_INTEGER(sprite_map(3)(5 downto 1)),13) + TO_UNSIGNED(8*(VcountR-TO_INTEGER(sprite_map(3)(15 downto 6))+Vextra),13) + sprite_pointer;
		  en_sprite 	   	<= '1';	 
			
		  if sprite_pointer = "111" then --review
			sprite_pointer <= "000";			  
			sprites_copied(3) <= '1';
		  else
			sprite_pointer <= sprite_pointer+1;
		  end if;
		elsif sprites_2_show(4)='1' and sprites_copied(4)='0' then
		  buffer_pointer	<= TO_UNSIGNED(8*4,7) + sprite_pointer;
		  sp_pointer	   	<= TO_UNSIGNED(256*TO_INTEGER(sprite_map(4)(5 downto 1)),13) + TO_UNSIGNED(8*(VcountR-TO_INTEGER(sprite_map(4)(15 downto 6))+Vextra),13) + sprite_pointer;
		  en_sprite 	   	<= '1';	 
			
		  if sprite_pointer = "111" then --review
			sprite_pointer <= "000";			  
			sprites_copied(4) <= '1';
		  else
			sprite_pointer <= sprite_pointer+1;
		  end if;
		elsif sprites_2_show(5)='1' and sprites_copied(5)='0' then
		  buffer_pointer	<= TO_UNSIGNED(8*5,7) + sprite_pointer;
		  sp_pointer	   	<= TO_UNSIGNED(256*TO_INTEGER(sprite_map(5)(5 downto 1)),13) + TO_UNSIGNED(8*(VcountR-TO_INTEGER(sprite_map(5)(15 downto 6))+Vextra),13) + sprite_pointer;
		  en_sprite 	   	<= '1';	 
			
		  if sprite_pointer = "111" then --review
			sprite_pointer <= "000";			  
			sprites_copied(5) <= '1';
		  else
			sprite_pointer <= sprite_pointer+1;
		  end if;
		elsif sprites_2_show(6)='1' and sprites_copied(6)='0' then
		  buffer_pointer	<= TO_UNSIGNED(8*6,7) + sprite_pointer;
		  sp_pointer	   	<= TO_UNSIGNED(256*TO_INTEGER(sprite_map(6)(5 downto 1)),13) + TO_UNSIGNED(8*(VcountR-TO_INTEGER(sprite_map(6)(15 downto 6))+Vextra),13) + sprite_pointer;
		  en_sprite 	   	<= '1';	 
			
		  if sprite_pointer = "111" then --review
			sprite_pointer <= "000";			  
			sprites_copied(6) <= '1';
		  else
			sprite_pointer <= sprite_pointer+1;
		  end if;
		elsif sprites_2_show(7)='1' and sprites_copied(7)='0' then
		  buffer_pointer	<= TO_UNSIGNED(8*7,7) + sprite_pointer;
		  sp_pointer	   	<= TO_UNSIGNED(256*TO_INTEGER(sprite_map(7)(5 downto 1)),13) + TO_UNSIGNED(8*(VcountR-TO_INTEGER(sprite_map(7)(15 downto 6))+Vextra),13) + sprite_pointer;
		  en_sprite 	   	<= '1';	 
			
		  if sprite_pointer = "111" then --review
			sprite_pointer <= "000";			  
			sprites_copied(7) <= '1';
		  else
			sprite_pointer <= sprite_pointer+1;
		  end if;
		elsif sprites_2_show(8)='1' and sprites_copied(8)='0' then
		  buffer_pointer	<= TO_UNSIGNED(8*8,7) + sprite_pointer;
		  sp_pointer	   	<= TO_UNSIGNED(256*TO_INTEGER(sprite_map(8)(5 downto 1)),13) + TO_UNSIGNED(8*(VcountR-TO_INTEGER(sprite_map(8)(15 downto 6))+Vextra),13) + sprite_pointer;
		  en_sprite 	   	<= '1';	 
			
		  if sprite_pointer = "111" then --review
			sprite_pointer <= "000";			  
			sprites_copied(8) <= '1';
		  else
			sprite_pointer <= sprite_pointer+1;
		  end if;
		elsif sprites_2_show(9)='1' and sprites_copied(9)='0' then
		  buffer_pointer	<= TO_UNSIGNED(8*9,7) + sprite_pointer;
		  sp_pointer	   	<= TO_UNSIGNED(256*TO_INTEGER(sprite_map(9)(5 downto 1)),13) + TO_UNSIGNED(8*(VcountR-TO_INTEGER(sprite_map(9)(15 downto 6))+Vextra),13) + sprite_pointer;
		  en_sprite 	   	<= '1';	 
			
		  if sprite_pointer = "111" then --review
			sprite_pointer <= "000";			  
			sprites_copied(9) <= '1';
		  else
			sprite_pointer <= sprite_pointer+1;
		  end if;
		elsif sprites_2_show(10)='1' and sprites_copied(10)='0' then
		  buffer_pointer	<= TO_UNSIGNED(8*10,7) + sprite_pointer;
		  sp_pointer	   	<= TO_UNSIGNED(256*TO_INTEGER(sprite_map(10)(5 downto 1)),13) + TO_UNSIGNED(8*(VcountR-TO_INTEGER(sprite_map(10)(15 downto 6))+Vextra),13) + sprite_pointer;
		  en_sprite 	   	<= '1';	 
			
		  if sprite_pointer = "111" then --review
			sprite_pointer <= "000";			  
			sprites_copied(10) <= '1';
		  else
			sprite_pointer <= sprite_pointer+1;
		  end if;
		elsif sprites_2_show(11)='1' and sprites_copied(11)='0' then
		  buffer_pointer	<= TO_UNSIGNED(8*11,7) + sprite_pointer;
		  sp_pointer	   	<= TO_UNSIGNED(256*TO_INTEGER(sprite_map(11)(5 downto 1)),13) + TO_UNSIGNED(8*(VcountR-TO_INTEGER(sprite_map(11)(15 downto 6))+Vextra),13) + sprite_pointer;
		  en_sprite 	   	<= '1';	 
			
		  if sprite_pointer = "111" then --review
			sprite_pointer <= "000";			  
			sprites_copied(11) <= '1';
		  else
			sprite_pointer <= sprite_pointer+1;
		  end if;
		elsif sprites_2_show(12)='1' and sprites_copied(12)='0' then
		  buffer_pointer	<= TO_UNSIGNED(8*12,7) + sprite_pointer;
		  sp_pointer	   	<= TO_UNSIGNED(256*TO_INTEGER(sprite_map(12)(5 downto 1)),13) + TO_UNSIGNED(8*(VcountR-TO_INTEGER(sprite_map(12)(15 downto 6))+Vextra),13) + sprite_pointer;
		  en_sprite 	   	<= '1';	 
			
		  if sprite_pointer = "111" then --review
			sprite_pointer <= "000";			  
			sprites_copied(12) <= '1';
		  else
			sprite_pointer <= sprite_pointer+1;
		  end if;
		elsif sprites_2_show(13)='1' and sprites_copied(13)='0' then
		  buffer_pointer	<= TO_UNSIGNED(8*13,7) + sprite_pointer;
		  sp_pointer	   	<= TO_UNSIGNED(256*TO_INTEGER(sprite_map(13)(5 downto 1)),13) + TO_UNSIGNED(8*(VcountR-TO_INTEGER(sprite_map(13)(15 downto 6))+Vextra),13) + sprite_pointer;
		  en_sprite 	   	<= '1';	 
			
		  if sprite_pointer = "111" then --review
			sprite_pointer <= "000";			  
			sprites_copied(13) <= '1';
		  else
			sprite_pointer <= sprite_pointer+1;
		  end if;
		elsif sprites_2_show(14)='1' and sprites_copied(14)='0' then
		  buffer_pointer	<= TO_UNSIGNED(8*14,7) + sprite_pointer;
		  sp_pointer	   	<= TO_UNSIGNED(256*TO_INTEGER(sprite_map(14)(5 downto 1)),13) + TO_UNSIGNED(8*(VcountR-TO_INTEGER(sprite_map(14)(15 downto 6))+Vextra),13) + sprite_pointer;
		  en_sprite 	   	<= '1';	 
			
		  if sprite_pointer = "111" then --review
			sprite_pointer <= "000";			  
			sprites_copied(14) <= '1';
		  else
			sprite_pointer <= sprite_pointer+1;
		  end if;
		elsif sprites_2_show(15)='1' and sprites_copied(15)='0' then
		  buffer_pointer	<= TO_UNSIGNED(8*15,7) + sprite_pointer;
		  sp_pointer	   	<= TO_UNSIGNED(256*TO_INTEGER(sprite_map(15)(5 downto 1)),13) + TO_UNSIGNED(8*(VcountR-TO_INTEGER(sprite_map(15)(15 downto 6))+Vextra),13) + sprite_pointer;
		  en_sprite 	   	<= '1';	 
			
		  if sprite_pointer = "111" then --review
			sprite_pointer <= "000";			  
			sprites_copied(15) <= '1';
		  else
			sprite_pointer <= sprite_pointer+1;
		  end if;
		end if;
	  end if;

	  if Hcount=TO_UNSIGNED(129,10) then	
		en_sprite <= '0';
	  end if;
		
	  if en_sprite='1' then
		en_sprite1 <= '1';
	  else
		en_sprite1 <= '0';
	  end if;

	  if en_sprite='1' then
		cop_sprite<= sprites(TO_INTEGER(sp_pointer));
		buffer_pointer1 <= buffer_pointer;
	  end if;

	  if en_sprite1='1' then		
		sprite_buffer(TO_INTEGER(buffer_pointer1)) <= cop_sprite;
	  else
		L1: for d in 0 to 15 loop	
		  if sprites_2_show(d)='1' and HcountR>=(TO_INTEGER(sprite_map(d)(25 downto 16))-Hextra) and HcountR<(TO_INTEGER(sprite_map(d)(25 downto 16))-Hextra+HSPRITE) then
			if sprite_map(d)(0)='0' then
			  L2: for c in 0 to 6 loop
				sprite_buffer(8*d+c)(31 downto 8)  <= sprite_buffer(8*d+c)(23 downto 0);
				sprite_buffer(8*d+c)(7 downto 0)   <= sprite_buffer(8*d+c+1)(31 downto 24);
			  end loop L2;

			  sprite_buffer(8*d+7)(31 downto 8) <= sprite_buffer(8*d+7)(23 downto 0);
			  sprite_buffer(8*d+7)(7 downto 0)  <= (others => '0');
			else
			  sprite_buffer(8*d+0)(31 downto 24) <= sprite_buffer(8*d+7)(7 downto 0);			
			  sprite_buffer(8*d+0)(23 downto 0)  <= sprite_buffer(8*d+0)(31 downto 8);		

			  L3: for c in 1 to 7 loop
				sprite_buffer(8*d+c)(31 downto 24) <= sprite_buffer(8*d+c-1)(7 downto 0);
				sprite_buffer(8*d+c)(23 downto 0)  <= sprite_buffer(8*d+c)(31 downto 8);
			  end loop L3;
			end if;
		  end if;
		end loop L1;
	  end if;	
  
	  if VcountR>=0 and VcountR<VACTIVE and Hcount>=TO_UNSIGNED(HSYNC+HBACK_PORCH-3,10) and Hcount<TO_UNSIGNED(HSYNC+HBACK_PORCH+HACTIVE-3,10) then --Cycle 141
		if tile_pixel_h = TO_UNSIGNED(63,7) then --updating counters for the tile
		  tile_pixel_h <= (others => '0');	
		else
		  tile_pixel_h <= tile_pixel_h + 1;
		end if;
	  end if;

	  if VcountR>=0 and VcountR<VACTIVE and Hcount=TO_UNSIGNED(HSYNC+HBACK_PORCH+HACTIVE-3,10) then	--cycle 141
		if Hextra < 64 then
		  tile_pixel_h <= TO_UNSIGNED(Hextra,7);
		elsif	Hextra < 128 then
		  tile_pixel_h <= TO_UNSIGNED(Hextra-64,7);
		elsif	Hextra < 192 then
		  tile_pixel_h <= TO_UNSIGNED(Hextra-128,7);
		elsif	Hextra < 256 then
		  tile_pixel_h <= TO_UNSIGNED(Hextra-192,7);
		elsif	Hextra < 320 then
		  tile_pixel_h <= TO_UNSIGNED(Hextra-256,7);
		elsif	Hextra < 384 then
		  tile_pixel_h <= TO_UNSIGNED(Hextra-320,7);
		end if;		
		
		if tile_pixel_v = TO_UNSIGNED(59,7) then
		  tile_pixel_v <= (others => '0');
		else
		  tile_pixel_v <= tile_pixel_v + 1;
		end if;
	  end if;

	  if Vcount = TO_UNSIGNED(0,10) then --before: if VcountR = VACTIVE then
		if Vextra < 60 then
		  tile_pixel_v <= TO_UNSIGNED(Vextra,7);
		elsif	Vextra < 120 then
		  tile_pixel_v <= TO_UNSIGNED(Vextra-60,7);
		elsif	Vextra < 180 then
		  tile_pixel_v <= TO_UNSIGNED(Vextra-120,7);
		elsif	Vextra < 240 then
		  tile_pixel_v <= TO_UNSIGNED(Vextra-180,7);
		elsif	Vextra < 300 then
		  tile_pixel_v <= TO_UNSIGNED(Vextra-240,7);
		elsif	Vextra < 360 then
		  tile_pixel_v <= TO_UNSIGNED(Vextra-300,7);
		elsif	Vextra < 420 then
		  tile_pixel_v <= TO_UNSIGNED(Vextra-360,7);
		elsif	Vextra < 480 then
		  tile_pixel_v <= TO_UNSIGNED(Vextra-420,7);
		elsif	Vextra < 540 then
		  tile_pixel_v <= TO_UNSIGNED(Vextra-480,7);
		elsif	Vextra < 600 then
		  tile_pixel_v <= TO_UNSIGNED(Vextra-540,7);
		end if;
		
		tile_pixel_h <= (others => '0');
	  end if;

	  if VcountR>=0 and VcountR<VACTIVE and Hcount>=TO_UNSIGNED(HSYNC+HBACK_PORCH-2,10) and Hcount<TO_UNSIGNED(HSYNC+HBACK_PORCH+HACTIVE-2,10) then	--Cycle 142
		tile_pixel <= tile(TO_INTEGER(tile_pixel_v*TO_UNSIGNED(64,8)+tile_pixel_h));
	  end if;

	  if VcountR>=0 and VcountR<VACTIVE and HcountR>=0 and HcountR<HACTIVE then --Cycle 143: 1 cycle before we arrive to the screen (we arrive at cycle 144, Hcount >= 144)
		if sprites_2_show(0)='1' and HcountR>=TO_INTEGER(sprite_map(0)(25 downto 16)-Hextra) and HcountR<(TO_INTEGER(sprite_map(0)(25 downto 16))+HSPRITE-Hextra) and sprite_buffer(8*0)(31 downto 24)/=TO_UNSIGNED(251,8) then--sprite_buffer(8*0)(31 downto 24)/=TO_UNSIGNED(3,8) and sprite_buffer(8*0)(31 downto 24)/=TO_UNSIGNED(10,8) and sprite_buffer(8*0)(31 downto 24)/=TO_UNSIGNED(27,8) and sprite_buffer(8*0)(31 downto 24)/=TO_UNSIGNED(36,8) and sprite_buffer(8*0)(31 downto 24)/=TO_UNSIGNED(45,8) and sprite_buffer(8*0)(31 downto 24)/=TO_UNSIGNED(54,8) and sprite_buffer(8*0)(31 downto 24)/=TO_UNSIGNED(63,8) and sprite_buffer(8*0)(31 downto 24)/=TO_UNSIGNED(73,8) and sprite_buffer(8*0)(31 downto 24)/=TO_UNSIGNED(82,8) and sprite_buffer(8*0)(31 downto 24)/=TO_UNSIGNED(91,8) and sprite_buffer(8*0)(31 downto 24)/=TO_UNSIGNED(100,8) and sprite_buffer(8*0)(31 downto 24)/=TO_UNSIGNED(109,8) and sprite_buffer(8*0)(31 downto 24)/=TO_UNSIGNED(118,8) and sprite_buffer(8*0)(31 downto 24)/=TO_UNSIGNED(127,8) and sprite_buffer(8*0)(31 downto 24)/=TO_UNSIGNED(251,8) then
		  color_2_show <= sprite_buffer(8*0)(31 downto 24);
		  show_spriteTile <= '1';
		elsif sprites_2_show(1)='1' and HcountR>=TO_INTEGER(sprite_map(1)(25 downto 16)-Hextra) and HcountR<(TO_INTEGER(sprite_map(1)(25 downto 16))+HSPRITE-Hextra) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(251,8) then--sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(3,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(10,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(27,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(36,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(45,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(54,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(63,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(73,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(82,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(91,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(100,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(109,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(118,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(127,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(251,8) then
		  color_2_show <= sprite_buffer(8*1)(31 downto 24);
		  show_spriteTile <= '1';
		elsif sprites_2_show(2)='1' and HcountR>=TO_INTEGER(sprite_map(2)(25 downto 16)-Hextra) and HcountR<(TO_INTEGER(sprite_map(2)(25 downto 16))+HSPRITE-Hextra) and sprite_buffer(8*2)(31 downto 24)/=TO_UNSIGNED(251,8) then--sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(3,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(10,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(27,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(36,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(45,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(54,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(63,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(73,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(82,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(91,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(100,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(109,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(118,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(127,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(251,8) then
		  color_2_show <= sprite_buffer(8*2)(31 downto 24);
		  show_spriteTile <= '1';
		elsif sprites_2_show(3)='1' and HcountR>=TO_INTEGER(sprite_map(3)(25 downto 16)-Hextra) and HcountR<(TO_INTEGER(sprite_map(3)(25 downto 16))+HSPRITE-Hextra) and sprite_buffer(8*3)(31 downto 24)/=TO_UNSIGNED(251,8) then--sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(3,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(10,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(27,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(36,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(45,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(54,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(63,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(73,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(82,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(91,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(100,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(109,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(118,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(127,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(251,8) then
		  color_2_show <= sprite_buffer(8*3)(31 downto 24);
		  show_spriteTile <= '1';
		elsif sprites_2_show(4)='1' and HcountR>=TO_INTEGER(sprite_map(4)(25 downto 16)-Hextra) and HcountR<(TO_INTEGER(sprite_map(4)(25 downto 16))+HSPRITE-Hextra) and sprite_buffer(8*4)(31 downto 24)/=TO_UNSIGNED(251,8) then--sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(3,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(10,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(27,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(36,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(45,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(54,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(63,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(73,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(82,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(91,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(100,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(109,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(118,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(127,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(251,8) then
		  color_2_show <= sprite_buffer(8*4)(31 downto 24);
		  show_spriteTile <= '1';
		elsif sprites_2_show(5)='1' and HcountR>=TO_INTEGER(sprite_map(5)(25 downto 16)-Hextra) and HcountR<(TO_INTEGER(sprite_map(5)(25 downto 16))+HSPRITE-Hextra) and sprite_buffer(8*5)(31 downto 24)/=TO_UNSIGNED(251,8) then--sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(3,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(10,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(27,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(36,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(45,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(54,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(63,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(73,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(82,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(91,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(100,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(109,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(118,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(127,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(251,8) then
		  color_2_show <= sprite_buffer(8*5)(31 downto 24);
		  show_spriteTile <= '1';
		elsif sprites_2_show(6)='1' and HcountR>=TO_INTEGER(sprite_map(6)(25 downto 16)-Hextra) and HcountR<(TO_INTEGER(sprite_map(6)(25 downto 16))+HSPRITE-Hextra) and sprite_buffer(8*6)(31 downto 24)/=TO_UNSIGNED(251,8) then--sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(3,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(10,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(27,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(36,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(45,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(54,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(63,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(73,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(82,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(91,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(100,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(109,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(118,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(127,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(251,8) then
		  color_2_show <= sprite_buffer(8*6)(31 downto 24);
		  show_spriteTile <= '1';
		elsif sprites_2_show(7)='1' and HcountR>=TO_INTEGER(sprite_map(7)(25 downto 16)-Hextra) and HcountR<(TO_INTEGER(sprite_map(7)(25 downto 16))+HSPRITE-Hextra) and sprite_buffer(8*7)(31 downto 24)/=TO_UNSIGNED(251,8) then--sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(3,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(10,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(27,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(36,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(45,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(54,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(63,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(73,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(82,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(91,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(100,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(109,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(118,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(127,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(251,8) then
		  color_2_show <= sprite_buffer(8*7)(31 downto 24);
		  show_spriteTile <= '1';
		elsif sprites_2_show(8)='1' and HcountR>=TO_INTEGER(sprite_map(8)(25 downto 16)-Hextra) and HcountR<(TO_INTEGER(sprite_map(8)(25 downto 16))+HSPRITE-Hextra) and sprite_buffer(8*8)(31 downto 24)/=TO_UNSIGNED(251,8) then--sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(3,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(10,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(27,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(36,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(45,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(54,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(63,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(73,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(82,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(91,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(100,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(109,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(118,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(127,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(251,8) then
		  color_2_show <= sprite_buffer(8*8)(31 downto 24);
		  show_spriteTile <= '1';
		elsif sprites_2_show(9)='1' and HcountR>=TO_INTEGER(sprite_map(9)(25 downto 16)-Hextra) and HcountR<(TO_INTEGER(sprite_map(9)(25 downto 16))+HSPRITE-Hextra) and sprite_buffer(8*9)(31 downto 24)/=TO_UNSIGNED(251,8) then--sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(3,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(10,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(27,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(36,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(45,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(54,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(63,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(73,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(82,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(91,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(100,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(109,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(118,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(127,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(251,8) then
		  color_2_show <= sprite_buffer(8*9)(31 downto 24);
		  show_spriteTile <= '1';
		elsif sprites_2_show(10)='1' and HcountR>=TO_INTEGER(sprite_map(10)(25 downto 16)-Hextra) and HcountR<(TO_INTEGER(sprite_map(10)(25 downto 16))+HSPRITE-Hextra) and sprite_buffer(8*10)(31 downto 24)/=TO_UNSIGNED(251,8) then--sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(3,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(10,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(27,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(36,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(45,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(54,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(63,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(73,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(82,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(91,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(100,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(109,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(118,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(127,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(251,8) then
		  color_2_show <= sprite_buffer(8*10)(31 downto 24);
		  show_spriteTile <= '1';
		elsif sprites_2_show(11)='1' and HcountR>=TO_INTEGER(sprite_map(11)(25 downto 16)-Hextra) and HcountR<(TO_INTEGER(sprite_map(11)(25 downto 16))+HSPRITE-Hextra) and sprite_buffer(8*11)(31 downto 24)/=TO_UNSIGNED(251,8) then--sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(3,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(10,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(27,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(36,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(45,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(54,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(63,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(73,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(82,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(91,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(100,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(109,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(118,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(127,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(251,8) then
		  color_2_show <= sprite_buffer(8*11)(31 downto 24);
		  show_spriteTile <= '1';
		elsif sprites_2_show(12)='1' and HcountR>=TO_INTEGER(sprite_map(12)(25 downto 16)-Hextra) and HcountR<(TO_INTEGER(sprite_map(12)(25 downto 16))+HSPRITE-Hextra) and sprite_buffer(8*12)(31 downto 24)/=TO_UNSIGNED(251,8) then--sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(3,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(10,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(27,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(36,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(45,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(54,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(63,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(73,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(82,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(91,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(100,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(109,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(118,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(127,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(251,8) then
		  color_2_show <= sprite_buffer(8*12)(31 downto 24);
		  show_spriteTile <= '1';
		elsif sprites_2_show(13)='1' and HcountR>=TO_INTEGER(sprite_map(13)(25 downto 16)-Hextra) and HcountR<(TO_INTEGER(sprite_map(13)(25 downto 16))+HSPRITE-Hextra) and sprite_buffer(8*13)(31 downto 24)/=TO_UNSIGNED(251,8) then--sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(3,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(10,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(27,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(36,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(45,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(54,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(63,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(73,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(82,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(91,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(100,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(109,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(118,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(127,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(251,8) then
		  color_2_show <= sprite_buffer(8*13)(31 downto 24);
		  show_spriteTile <= '1';
		elsif sprites_2_show(14)='1' and HcountR>=TO_INTEGER(sprite_map(14)(25 downto 16)-Hextra) and HcountR<(TO_INTEGER(sprite_map(14)(25 downto 16))+HSPRITE-Hextra) and sprite_buffer(8*14)(31 downto 24)/=TO_UNSIGNED(251,8) then--sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(3,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(10,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(27,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(36,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(45,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(54,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(63,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(73,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(82,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(91,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(100,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(109,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(118,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(127,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(251,8) then
		  color_2_show <= sprite_buffer(8*14)(31 downto 24);
		  show_spriteTile <= '1';
		elsif sprites_2_show(15)='1' and HcountR>=TO_INTEGER(sprite_map(15)(25 downto 16)-Hextra) and HcountR<(TO_INTEGER(sprite_map(15)(25 downto 16))+HSPRITE-Hextra) and sprite_buffer(8*15)(31 downto 24)/=TO_UNSIGNED(251,8) then--sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(3,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(10,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(27,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(36,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(45,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(54,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(63,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(73,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(82,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(91,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(100,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(109,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(118,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(127,8) and sprite_buffer(8*1)(31 downto 24)/=TO_UNSIGNED(251,8) then
		  color_2_show <= sprite_buffer(8*15)(31 downto 24);
		  show_spriteTile <= '1';
		elsif VcountR > (TO_INTEGER(old_transparency)-Vextra) then	--show tile	
		  color_2_show <= tile_pixel;
		  show_spriteTile <= '1';
		else
		  color_2_show <= (others => '0');
		  show_spriteTile <= '0'; 		
		end if;			
	  end if;
		
	  if show_spriteTile='1' then	--Cycle 144: get color for next pixel, visible in the cycle 145		
		colorInternal <= color(TO_INTEGER(color_2_show));	--show sprite or tile	
		show_something <= '1';
	  else
		show_something <= '0';
	  end if;

	end if;	
  end process SpriteGen;

  Communication : process(clk)	--Communication from the SW
  begin
	if rising_edge(clk)then
	  if chipselect = '1' and write = '1' and address = "001" then
		transparency(TO_INTEGER(tranCounter)) <= unsigned(TO_UNSIGNED(1023,10) - unsigned(writedata(9 downto 0)));
	  end if;
	
	  if (HcountR+1+Hextra)<1024 then	
		old_transparency <= transparency(HcountR+1+Hextra);
	  end if;
	
	  if chipselect = '1' and write = '1' then
		if address = "000" then
		  tranCounter <= (others => '0');
		elsif address = "001" then		
		  if tranCounter = TO_UNSIGNED(1023,10) then 
			tranCounter <= (others => '0');
		  else
			tranCounter <= tranCounter + 1;
		  end if;											--	 [31	   27|   26	  |25 16|15  6|5        1|     0 	   ]
		elsif address = "010" then --sprites from the SW, format: [SpriteID(5)|shown(1)|H(10)|V(10)|sprite#(5)|spriteFlip(1)]
		  if writedata(26) = '1' then
			sprite_map(TO_INTEGER(writedata(31 downto 27))) <= (writedata(26 downto 0));	
		  else
			sprite_map(TO_INTEGER(writedata(31 downto 27))) <= (others => '0');
		  end if;
		elsif address = "011" then
		  sprite_map <= (others => (others => '0'));
		  Hextra 	 <= 0;
		  Vextra 	 <= 0;
		elsif address = "100" then
		  Hextra <= TO_INTEGER(writedata(31 downto 22));
		  Vextra <= TO_INTEGER(writedata(21 downto 12));
		end if;
	  end if;
	
	  if chipselect = '1' and read = '1' then
		if address = "000" then
			readdata <= random;
		end if;
	  end if;
	end if;
  end process Communication;
 
  VideoOut : process (clk25)	-- Registered video signals going to the video DAC
  begin
	if rising_edge(clk25) then
	  if reset = '1' then
		VGA_R <= "0000000000";
		VGA_G <= "0000000000";
		VGA_B <= "0000000000";
	  else
		if vga_hblank = '0' and vga_vblank ='0' then  	--paint a sprite/tile (cycle 145)	
		  if show_something = '1' then	
			VGA_R <= colorInternal(31 downto 22);  
			VGA_G <= colorInternal(21 downto 12);
			VGA_B <= colorInternal(11 downto 2);
		  else
			VGA_R <= "0000000000";	--VGA_R_IN;		--paint background
			VGA_G <= "0000000000";	--VGA_G_IN;
			VGA_B <= "0000000000";	--VGA_B_IN;
		  end if;
		else							--out of the visible area (synchronization signals)
          VGA_R <= "0000000000";
          VGA_G <= "0000000000";
          VGA_B <= "0000000000";    
		end if;
	  end if;
    end if;
  end process VideoOut;

  VGA_CLK <= clk25;
  VGA_HS <= not vga_hsync;
  VGA_VS <= not vga_vsync;
  VGA_SYNC <= '0';
  VGA_BLANK <= not (vga_hsync or vga_vsync);

end rtl;

							--	 [31	   27|   26	  |25 16|15  6|5        1|     0 	   ]
  --sprites from the SW, format: [SpriteID(5)|shown(1)|H(10)|V(10)|sprite#(5)|spriteFlip(1)]
  --cycles needed to paint a sprite (new): (sprite starts at 144, HSYNC + HBACK_PORCH = 144)
  --cycle 0		: determine sprites in this row.
  --cycle 1-128	: copy them to the 16 shift registers.
  --cycle 140	: Hcounter >= HSYNC+HBACKPORCH and Vcounter >= VSYNC+VBACKPORCH-1 then show the first sprite
  --cycle 141	: if in that pixel there is no sprite, show tile, if not show background. If there is one or more sprites, compare all and show the 1st not transparent, at the same time shift all the registers in the right/left direction (it depends on the FlipBit)
  --cycle 142	: look for color information in the color table.
  --cycle 143	: show RGB color
